/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.dom.DOMTreeWithPreview;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JComponent;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class HTMLHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 4859255638148506547L;

    public String globalInfo() {
        return "Displays HTML files: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"html", "htm"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewPanel createPreview(File file) {
        PreviewPanel result;
        FileInputStream fis = null;
        try {
            DOMParser parser = new DOMParser();
            fis = new FileInputStream(file.getAbsoluteFile());
            parser.parse(new InputSource(fis));
            Document doc = parser.getDocument();
            DOMTreeWithPreview domPanel = new DOMTreeWithPreview();
            domPanel.setDOM((Node)doc);
            domPanel.getTree().expandAll();
            domPanel.setSplitterPosition(500);
            result = new PreviewPanel((JComponent)domPanel);
        }
        catch (Exception e) {
            try {
                TextEditorPanel textPanel = new TextEditorPanel();
                textPanel.open(file);
                textPanel.setEditable(false);
                result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }
}

