/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractOptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionUser;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.DatabaseConnectionProvider;
import adams.flow.webservice.ImageServiceWS;
import adams.flow.webservice.OwnedByImageServiceWS;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import nz.ac.waikato.adams.webservice.image.ImageService;
import nz.ac.waikato.adams.webservice.image.UploadRequest;
import nz.ac.waikato.adams.webservice.image.UploadResponse;

public class SimpleImageService
extends AbstractOptionHandler
implements ImageService,
OwnedByImageServiceWS,
DatabaseConnectionUser {
    private static final long serialVersionUID = -6102580694812360595L;
    protected ImageServiceWS m_Owner;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected PlaceholderDirectory m_UploadDir;

    public SimpleImageService() {
        this.setOwner(null);
    }

    public String globalInfo() {
        return "Simple implementation of a Image webservice.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("upload-dir", "uploadDir", (Object)new PlaceholderDirectory("${TMP}"));
    }

    public void setUploadDir(PlaceholderDirectory value) {
        this.m_UploadDir = value;
        this.reset();
    }

    public PlaceholderDirectory getUploadDir() {
        return this.m_UploadDir;
    }

    public String uploadDirTipText() {
        return "The upload directory to store the images in.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((Actor)this.m_Owner.getFlowContext(), DatabaseConnectionProvider.class, (AbstractDatabaseConnection)DatabaseConnection.getSingleton());
    }

    @Override
    public void setOwner(ImageServiceWS value) {
        this.m_Owner = value;
        this.m_DatabaseConnection = this.m_Owner != null && this.m_Owner.getFlowContext() != null ? this.getDatabaseConnection() : null;
    }

    @Override
    public ImageServiceWS getOwner() {
        return this.m_Owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadResponse upload(UploadRequest parameters) {
        this.m_Owner.getLogger().info("upload: " + parameters.getId() + "/" + (Object)((Object)parameters.getFormat()));
        UploadResponse result = new UploadResponse();
        result.setId(parameters.getId());
        result.setFormat(parameters.getFormat());
        String filename = parameters.getId() + "." + parameters.getFormat().toString().toLowerCase();
        filename = this.m_UploadDir.getAbsolutePath() + File.separator + FileUtils.createFilename((String)filename, (String)"_");
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            int data;
            fos = new FileOutputStream(filename);
            bos = new BufferedOutputStream(fos);
            InputStream ins = parameters.getImage().getData().getInputStream();
            while ((data = ins.read()) != -1) {
                bos.write(data);
            }
            bos.flush();
            bos.close();
            result.setSuccess(true);
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to store image '" + parameters.getId() + "/" + (Object)((Object)parameters.getFormat()) + "' as '" + filename + "'!", (Throwable)e);
                result.setMessage("Failed to store image '" + parameters.getId() + "/" + (Object)((Object)parameters.getFormat()) + ":\n" + LoggingHelper.throwableToString((Throwable)e));
                result.setSuccess(true);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(bos);
                FileUtils.closeQuietly((OutputStream)fos);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)bos);
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((OutputStream)bos);
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

