/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.flow.core.Actor;
import adams.flow.webservice.AbstractWebServiceClientSink;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.ws.BindingProvider;
import nz.ac.waikato.adams.webservice.image.Image;
import nz.ac.waikato.adams.webservice.image.ImageFormat;
import nz.ac.waikato.adams.webservice.image.ImageService;
import nz.ac.waikato.adams.webservice.image.ImageServiceService;
import nz.ac.waikato.adams.webservice.image.UploadRequest;
import nz.ac.waikato.adams.webservice.image.UploadResponse;

public class Upload
extends AbstractWebServiceClientSink<byte[]> {
    private static final long serialVersionUID = -338043583699608760L;
    protected String m_ID;
    protected ImageFormat m_Format;
    protected byte[] m_ImageIn;
    protected transient ImageServiceService m_Service;
    protected transient ImageService m_Port;

    public String globalInfo() {
        return "Stores a spectrum using the Image web service.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)"");
        this.m_OptionManager.add("format", "format", (Object)ImageFormat.PNG);
    }

    protected void reset() {
        super.reset();
        this.m_Service = null;
        this.m_Port = null;
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID of the image to upload.";
    }

    public void setFormat(ImageFormat value) {
        this.m_Format = value;
        this.reset();
    }

    public ImageFormat getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The image format.";
    }

    public Class[] accepts() {
        return new Class[]{byte[].class};
    }

    public URL getWsdlLocation() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("wsdl/image/ImageService.wsdl");
    }

    public void setRequestData(byte[] value) {
        this.m_ImageIn = value;
    }

    protected void doQuery() throws Exception {
        if (this.m_Service == null) {
            this.m_Service = new ImageServiceService(this.getWsdlLocation());
            this.m_Port = this.m_Service.getImageServicePort();
            WebserviceUtils.configureClient((Actor)this.m_Owner, (Object)this.m_Port, (int)this.m_ConnectionTimeout, (int)this.m_ReceiveTimeout, (String)(this.getUseAlternativeURL() ? this.getAlternativeURL() : null), null, (AbstractOutInterceptorGenerator)this.m_OutInterceptor);
            WebserviceUtils.enableSchemaValidation((BindingProvider)((BindingProvider)this.m_Port));
        }
        UploadRequest request = new UploadRequest();
        request.setId(this.m_ID);
        request.setFormat(this.m_Format);
        Image img = new Image();
        img.setData(new DataHandler((DataSource)new ByteArrayDataSource(this.m_ImageIn, "application/octet-stream")));
        request.setImage(img);
        UploadResponse response = this.m_Port.upload(request);
        if (!response.isSuccess()) {
            throw new IllegalStateException(response.getMessage());
        }
    }

    public void cleanUp() {
        this.m_Service = null;
        this.m_Port = null;
        super.cleanUp();
    }
}

