/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageType;
import adams.data.image.AbstractImageContainer;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import boofcv.abst.feature.detect.line.DetectLineHoughPolar;
import boofcv.factory.feature.detect.line.ConfigHoughPolar;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.line.LineParametric2D_F32;
import java.util.List;

@MixedCopyright(copyright="2011-2012 Peter Abeles", license=License.APACHE2, note="Example code taken from here http://boofcv.org/index.php?title=Example_Detect_Lines")
public class BoofCVDetectLines
extends AbstractTransformer {
    private static final long serialVersionUID = 2784091483353536513L;
    protected int m_LocalMaxRadius;
    protected int m_MinCounts;
    protected double m_ResolutionRange;
    protected double m_ResolutionAngle;
    protected float m_EdgeThreshold;
    protected int m_MaxLines;

    public String globalInfo() {
        return "Detects lines in images (Hough line detector based on polar parametrization).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("local-max-radius", "localMaxRadius", (Object)3, (Number)0, null);
        this.m_OptionManager.add("min-counts", "minCounts", (Object)30, (Number)1, null);
        this.m_OptionManager.add("resolution-range", "resolutionRange", (Object)2.0, (Number)0.0, null);
        this.m_OptionManager.add("resolution-angle", "resolutionAngle", (Object)(Math.PI / 180), (Number)0.0, null);
        this.m_OptionManager.add("edge-threshold", "edgeThreshold", (Object)Float.valueOf(25.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("max-lines", "maxLines", (Object)10, (Number)1, null);
    }

    public void setLocalMaxRadius(int value) {
        if (value >= 0) {
            this.m_LocalMaxRadius = value;
            this.reset();
        } else {
            this.getLogger().warning("Local max radius must be at least 0, provided: " + value);
        }
    }

    public int getLocalMaxRadius() {
        return this.m_LocalMaxRadius;
    }

    public String localMaxRadiusTipText() {
        return "The Radius for local maximum suppression.";
    }

    public void setMinCounts(int value) {
        if (value >= 0) {
            this.m_MinCounts = value;
            this.reset();
        } else {
            this.getLogger().warning("Min counts must be at least 0, provided: " + value);
        }
    }

    public int getMinCounts() {
        return this.m_MinCounts;
    }

    public String minCountsTipText() {
        return "The Minimum number of counts for detected line.";
    }

    public void setResolutionRange(double value) {
        if (value >= 0.0) {
            this.m_ResolutionRange = value;
            this.reset();
        } else {
            this.getLogger().warning("Edge threshold must be at least 0, provided: " + value);
        }
    }

    public double getResolutionRange() {
        return this.m_ResolutionRange;
    }

    public String resolutionRangeTipText() {
        return "The Resolution of line range in pixels.";
    }

    public void setResolutionAngle(double value) {
        if (value >= 0.0) {
            this.m_ResolutionAngle = value;
            this.reset();
        } else {
            this.getLogger().warning("Edge threshold must be at least 0, provided: " + value);
        }
    }

    public double getResolutionAngle() {
        return this.m_ResolutionAngle;
    }

    public String resolutionAngleTipText() {
        return "The Resolution of line angle in radius.";
    }

    public void setEdgeThreshold(float value) {
        if (value >= 0.0f) {
            this.m_EdgeThreshold = value;
            this.reset();
        } else {
            this.getLogger().warning("Edge threshold must be at least 0, provided: " + value);
        }
    }

    public float getEdgeThreshold() {
        return this.m_EdgeThreshold;
    }

    public String edgeThresholdTipText() {
        return "The edge threshold to use.";
    }

    public void setMaxLines(int value) {
        this.m_MaxLines = value;
        this.reset();
    }

    public int getMaxLines() {
        return this.m_MaxLines;
    }

    public String maxLinesTipText() {
        return "The maximum number of lines to detect.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
            ImageUInt8 input = (ImageUInt8)BoofCVHelper.toBoofCVImage(cont, BoofCVImageType.UNSIGNED_INT_8);
            ConfigHoughPolar config = new ConfigHoughPolar(this.m_LocalMaxRadius, this.m_MinCounts, this.m_ResolutionRange, this.m_ResolutionAngle, this.m_EdgeThreshold, this.m_MaxLines);
            DetectLineHoughPolar detector = FactoryDetectLineAlgs.houghPolar((ConfigHoughPolar)config, ImageUInt8.class, ImageSInt16.class);
            List found = detector.detect((ImageSingleBand)input);
            SpreadSheet sheet = new SpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("I").setContent("Index");
            row.addCell("SX").setContent("Slope X");
            row.addCell("SY").setContent("Slope Y");
            row.addCell("X").setContent("X");
            row.addCell("Y").setContent("Y");
            row.addCell("A").setContent("Angle");
            for (LineParametric2D_F32 line : found) {
                row = sheet.addRow();
                row.addCell("I").setContent(Integer.valueOf(sheet.getRowCount()));
                row.addCell("SX").setContent(Float.valueOf(line.getSlopeX()));
                row.addCell("SY").setContent(Float.valueOf(line.getSlopeY()));
                row.addCell("X").setContent(Float.valueOf(line.getX()));
                row.addCell("Y").setContent(Float.valueOf(line.getY()));
                row.addCell("A").setContent(Float.valueOf(line.getAngle()));
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to detect lines", e);
        }
        return result;
    }
}

