/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.image.BoofCVDetectLinesImageOverlay;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPluginWithGOE;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.image.ImageUInt8;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;

public class BoofCVDetectLines
extends AbstractImageViewerPluginWithGOE {
    private static final long serialVersionUID = 3286345601880725626L;
    protected BoofCVDetectLinesImageOverlay m_Overlay;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "BoofCV detect lines...";
    }

    public String getIconName() {
        return "lines.png";
    }

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected boolean getCanChangeClassInDialog() {
        return false;
    }

    protected Class getEditorType() {
        return Actor.class;
    }

    protected Object getDefaultValue() {
        return new adams.flow.transformer.BoofCVDetectLines();
    }

    protected String createLogEntry() {
        return OptionUtils.getCommandLine((Object)this.getLastSetup());
    }

    protected String process() {
        String result = null;
        BoofCVImageContainer cont = new BoofCVImageContainer();
        cont.setImage(ConvertBufferedImage.convertFromSingle((BufferedImage)((ImagePanel)this.m_CurrentPanel).getCurrentImage(), null, ImageUInt8.class));
        adams.flow.transformer.BoofCVDetectLines detect = (adams.flow.transformer.BoofCVDetectLines)((Object)this.getLastSetup());
        detect.input(new Token((Object)cont));
        result = detect.execute();
        if (result == null) {
            if (detect.hasPendingOutput()) {
                SpreadSheet sheet = (SpreadSheet)detect.output().getPayload();
                this.m_Overlay = new BoofCVDetectLinesImageOverlay();
                this.m_Overlay.setLines(sheet);
                ((ImagePanel)this.m_CurrentPanel).removeImageOverlays(BoofCVDetectLinesImageOverlay.class);
                ((ImagePanel)this.m_CurrentPanel).addImageOverlay((ImageOverlay)this.m_Overlay);
                SpreadSheetDialog dlg = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new SpreadSheetDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog()) : new SpreadSheetDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame());
                dlg.setDefaultCloseOperation(2);
                dlg.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ((ImagePanel)BoofCVDetectLines.this.m_CurrentPanel).removeImageOverlay((ImageOverlay)BoofCVDetectLines.this.m_Overlay);
                        super.windowClosing(e);
                    }
                });
                String title = "BoofCV detect lines";
                if (((ImagePanel)this.m_CurrentPanel).getCurrentFile() != null) {
                    title = title + " [" + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getName() + " - " + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getParentFile() + "]";
                }
                dlg.setTitle(title);
                dlg.setSpreadSheet(sheet);
                dlg.setLocationRelativeTo((Component)this.m_CurrentPanel);
                dlg.setVisible(true);
            } else {
                result = "No output generated?";
            }
        }
        return result;
    }
}

