/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.boofcv.features.Pixels;
import adams.data.conversion.BufferedImageToBoofCV;
import adams.data.conversion.Conversion;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.jai.transformer.Resize;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.BoofCVFeatureGenerator;
import adams.flow.transformer.BufferedImageTransformer;
import adams.flow.transformer.Convert;
import adams.flow.transformer.ImageReader;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BoofCVFeatureGeneratorTest
extends AbstractFlowTest {
    public BoofCVFeatureGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.copyResourceToTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_icon.png");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier mfs = new FileSupplier();
        mfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png"), new TmpFile("adams_icon.png")});
        ImageReader ir = new ImageReader();
        BufferedImageTransformer trans = new BufferedImageTransformer();
        Resize res = new Resize();
        res.setWidth(16.0);
        res.setHeight(16.0);
        trans.setTransformAlgorithm((AbstractBufferedImageTransformer)res);
        BufferedImageToBoofCV bi2bcv = new BufferedImageToBoofCV();
        bi2bcv.setImageType(BoofCVImageType.SIGNED_INT_16);
        Convert con = new Convert();
        con.setConversion((Conversion)bi2bcv);
        BoofCVFeatureGenerator ifl = new BoofCVFeatureGenerator();
        Pixels pix = new Pixels();
        ifl.setAlgorithm((AbstractBoofCVFeatureGenerator)pix);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{mfs, ir, trans, con, ifl, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.csv"));
    }

    public static Test suite() {
        return new TestSuite(BoofCVFeatureGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        AdamsTestCase.runTest((Test)BoofCVFeatureGeneratorTest.suite());
    }
}

