/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;
import java.util.List;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="https://github.com/lessthanoptimal/BoofCV/blob/v0.15/examples/src/boofcv/examples/ExampleFitEllipse.java", note="Code taken from this BoofCV example")
public class BinaryContours
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -95759083210389706L;
    protected boolean m_RemoveSmallBlobs;
    protected ConnectRule m_ConnectRule;

    public String globalInfo() {
        return "Uses the BoofCV binary contours algorithm to detect edges in a binary image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove-small-blobs", "removeSmallBlobs", (Object)false);
        this.m_OptionManager.add("connect-rule", "connectRule", (Object)ConnectRule.EIGHT);
    }

    public void setRemoveSmallBlobs(boolean value) {
        this.m_RemoveSmallBlobs = value;
        this.reset();
    }

    public boolean getRemoveSmallBlobs() {
        return this.m_RemoveSmallBlobs;
    }

    public String removeSmallBlobsTipText() {
        return "If enabled, small blobs are removed using erode8/dilate8.";
    }

    public void setConnectRule(ConnectRule value) {
        this.m_ConnectRule = value;
        this.reset();
    }

    public ConnectRule getConnectRule() {
        return this.m_ConnectRule;
    }

    public String connectRuleTipText() {
        return "The connect rule to apply.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 filtered;
        ImageUInt8 input = (ImageUInt8)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.UNSIGNED_INT_8);
        if (this.m_RemoveSmallBlobs) {
            filtered = BinaryImageOps.erode8((ImageUInt8)input, (int)1, null);
            filtered = BinaryImageOps.dilate8((ImageUInt8)filtered, (int)1, null);
        } else {
            filtered = input;
        }
        List contours = BinaryImageOps.contour((ImageUInt8)filtered, (ConnectRule)this.m_ConnectRule, null);
        BufferedImage rendered = VisualizeBinaryData.renderExternal((List)contours, null, (int)input.width, (int)input.height, null);
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(ConvertBufferedImage.convertFromSingle((BufferedImage)rendered, null, ImageUInt8.class));
        return result;
    }
}

