/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.BoofCVImageReader;
import adams.data.io.output.AbstractImageWriter;
import boofcv.io.image.UtilImageIO;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;

public class BoofCVImageWriter
extends AbstractImageWriter<BoofCVImageContainer> {
    private static final long serialVersionUID = 6385191315392140321L;
    protected String[] m_FormatExtensions;

    public String globalInfo() {
        return "BoofCV image writer for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\nFor more information see:\nhttp://boofcv.org/";
    }

    protected void initialize() {
        super.initialize();
        ArrayList<String> formats = new ArrayList<String>();
        formats.addAll(Arrays.asList(ImageIO.getWriterFileSuffixes()));
        if (!formats.contains("ppm")) {
            formats.add("ppm");
        }
        if (!formats.contains("pgm")) {
            formats.add("pgm");
        }
        Collections.sort(formats);
        this.m_FormatExtensions = formats.toArray(new String[formats.size()]);
    }

    public String getFormatDescription() {
        return "BoofCV";
    }

    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    public AbstractImageReader getCorrespondingReader() {
        return new BoofCVImageReader();
    }

    protected String doWrite(PlaceholderFile file, BoofCVImageContainer cont) {
        UtilImageIO.saveImage((BufferedImage)cont.toBufferedImage(), (String)file.getAbsolutePath());
        return null;
    }
}

