/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.features;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.boofcv.features.Pixels;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.boofcv.transformer.PassThrough;
import adams.data.featureconverter.HeaderDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilteredBoofCVFeatureGenerator
extends AbstractBoofCVFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected AbstractBoofCVTransformer m_Filter;
    protected AbstractBoofCVFeatureGenerator m_Generator;

    public String globalInfo() {
        return "Applies the filter (an image transformer) to the image first before generating the features from the transformed images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
        this.m_OptionManager.add("generator", "generator", (Object)new Pixels());
    }

    public void setFilter(AbstractBoofCVTransformer value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractBoofCVTransformer getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use.";
    }

    public void setGenerator(AbstractBoofCVFeatureGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractBoofCVFeatureGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use on the filtered data.";
    }

    public HeaderDefinition createHeader(BoofCVImageContainer img) {
        BoofCVImageContainer[] conts = (BoofCVImageContainer[])this.m_Filter.transform(img);
        HeaderDefinition result = this.m_Generator.postProcessHeader(this.m_Generator.createHeader(conts[0]));
        return result;
    }

    public List<Object>[] generateRows(BoofCVImageContainer img) {
        List[] result;
        BoofCVImageContainer[] conts;
        ArrayList<List> rows = new ArrayList<List>();
        for (BoofCVImageContainer cont : conts = (BoofCVImageContainer[])this.m_Filter.transform(img)) {
            result = this.m_Generator.postProcessRows(cont, this.m_Generator.generateRows(cont));
            rows.addAll(Arrays.asList(result));
        }
        result = new List[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            result[i] = (List)rows.get(i);
        }
        return result;
    }
}

