/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.features;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;
import java.util.ArrayList;
import java.util.List;

public class Histogram
extends AbstractBoofCVFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Generates a histogram from the image. Supported image types:\n" + ImageUInt8.class.getName();
    }

    public HeaderDefinition createHeader(BoofCVImageContainer img) {
        if (!(img.getImage() instanceof ImageUInt8)) {
            throw new IllegalStateException("Unhandled image type: " + ((ImageBase)img.getImage()).getClass().getName());
        }
        int numHistogram = 256;
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < numHistogram; ++i) {
            result.add("att_" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    public List<Object>[] generateRows(BoofCVImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        if (img.getImage() instanceof ImageUInt8) {
            int[] histogram = new int[256];
            ImageStatistics.histogram((ImageUInt8)((ImageUInt8)img.getImage()), (int[])histogram);
            for (int value : histogram) {
                result[0].add(value);
            }
        } else {
            throw new IllegalStateException("Unhandled image type: " + ((ImageBase)img.getImage()).getClass().getName());
        }
        return result;
    }
}

