/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

public class Dilate8
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -95759083210389706L;
    protected int m_NumTimes;

    public String globalInfo() {
        return "Applies the BoofCV dilate8 algorithm to a binary image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-times", "numTimes", (Object)1, (Number)1, null);
    }

    public void setNumTimes(int value) {
        this.m_NumTimes = value;
        this.reset();
    }

    public int getNumTimes() {
        return this.m_NumTimes;
    }

    public String numTimesTipText() {
        return "The number of times to apply this operation.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 input = (ImageUInt8)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 filtered = BinaryImageOps.dilate8((ImageUInt8)input, (int)this.m_NumTimes, null);
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(filtered);
        return result;
    }
}

