/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.abst.denoise.FactoryImageDenoise;
import boofcv.abst.denoise.WaveletDenoiseFilter;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="http://boofcv.org/index.php?title=Example_Wavelet_Noise_Removal", note="Example code taken from this URL")
public class WaveletDenoise
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -465068613851000709L;
    protected int m_NumLevels;

    public String globalInfo() {
        return "Removes noise using wavelet transformation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-levels", "numLevels", (Object)3, (Number)1, null);
    }

    public void setNumLevels(int value) {
        this.m_NumLevels = value;
        this.reset();
    }

    public int getNumLevels() {
        return this.m_NumLevels;
    }

    public String numLevelsTipText() {
        return "The number of levels to use.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageFloat32 input = (ImageFloat32)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.FLOAT_32);
        ImageFloat32 denoised = new ImageFloat32(input.width, input.height);
        WaveletDenoiseFilter denoiser = FactoryImageDenoise.waveletBayes(ImageFloat32.class, (int)this.m_NumLevels, (double)0.0, (double)255.0);
        denoiser.process((ImageSingleBand)input, (ImageSingleBand)denoised);
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(denoised);
        return result;
    }
}

