/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.boofcv.transformer.PassThrough;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFilterWithGOE;
import java.awt.image.BufferedImage;

public class BoofCVTransformer
extends AbstractSelectedImagesFilterWithGOE {
    private static final long serialVersionUID = -3146372359577147914L;

    public String getMenu() {
        return "Filter";
    }

    public String getCaption() {
        return "BoofCV transformer...";
    }

    public String getIconName() {
        return "boofcv.png";
    }

    protected Class getEditorType() {
        return AbstractBoofCVTransformer.class;
    }

    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBoofCVTransformer transformer = (AbstractBoofCVTransformer)((Object)this.getLastSetup());
        BoofCVImageContainer input = new BoofCVImageContainer();
        input.setImage(BoofCVHelper.toBoofCVImage(image));
        BoofCVImageContainer[] transformed = (BoofCVImageContainer[])transformer.transform(input);
        if (transformed.length == 0) {
            this.m_FilterError = "No filtered image generated!";
        }
        if (transformed.length > 1) {
            this.getLogger().warning("Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = transformed[0].toBufferedImage();
        }
        return result;
    }
}

