/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.multiimageoperation;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.multiimageoperation.AbstractBoofCVMultiImageOperation;
import adams.data.image.AbstractImageContainer;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

public class And
extends AbstractBoofCVMultiImageOperation {
    private static final long serialVersionUID = -3399149520525668500L;

    public String globalInfo() {
        return "Performs a logical AND on the  binary pixels of the images.\nConverts images automatically to type " + (Object)((Object)BoofCVImageType.UNSIGNED_INT_8) + ".";
    }

    public int minNumImagesRequired() {
        return 2;
    }

    public int maxNumImagesRequired() {
        return -1;
    }

    protected void check(BoofCVImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions(images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BoofCVImageContainer[] doProcess(BoofCVImageContainer[] images) {
        int i;
        BoofCVImageContainer[] result = new BoofCVImageContainer[1];
        ImageUInt8[] img = new ImageUInt8[images.length];
        for (i = 0; i < images.length; ++i) {
            img[i] = (ImageUInt8)BoofCVHelper.toBoofCVImage(images[i], BoofCVImageType.UNSIGNED_INT_8);
        }
        ImageUInt8 output = (ImageUInt8)BoofCVHelper.clone((ImageBase)img[0]);
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int val = img[0].get(x, y);
                boolean same = true;
                for (i = 1; i < img.length; ++i) {
                    if (val == img[i].get(x, y)) continue;
                    same = false;
                }
                output.set(x, y, same ? 0 : 1);
            }
        }
        result[0] = new BoofCVImageContainer();
        result[0].setImage(output);
        return result;
    }
}

