/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.multiimageoperation;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.multiimageoperation.AbstractBoofCVMultiImageOperation;
import adams.data.image.AbstractImageContainer;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

public class Diff
extends AbstractBoofCVMultiImageOperation {
    private static final long serialVersionUID = -4576060482553726848L;
    protected int m_Threshold;

    public String globalInfo() {
        return "Compares two images and returns a third image with the differences between them";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)0, (Number)0, null);
    }

    public void setThreshold(int value) {
        if (this.getOptionManager().isValid("threshold", (Number)value)) {
            this.m_Threshold = value;
            this.reset();
        }
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold to use, based on absolute difference between pixel values.";
    }

    public int minNumImagesRequired() {
        return 2;
    }

    public int maxNumImagesRequired() {
        return 2;
    }

    protected void check(BoofCVImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions(images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected int thresholdEquals(int value1, int value2) {
        return Math.abs(value1 - value2) < this.m_Threshold ? -1 : 1;
    }

    protected BoofCVImageContainer[] doProcess(BoofCVImageContainer[] images) {
        ImageUInt8 output = new ImageUInt8(images[0].getWidth(), images[0].getHeight());
        BoofCVImageContainer[] result = new BoofCVImageContainer[1];
        ImageUInt8[] processed = new ImageUInt8[images.length];
        for (int i = 0; i < images.length; ++i) {
            processed[i] = (ImageUInt8)BoofCVHelper.toBoofCVImage((ImageBase)images[i].getImage(), BoofCVImageType.UNSIGNED_INT_8);
        }
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                output.set(x, y, this.thresholdEquals(processed[0].get(x, y), processed[1].get(x, y)));
            }
        }
        result[0] = new BoofCVImageContainer();
        result[0].setImage(output);
        return result;
    }
}

