/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.multiimageoperation;

import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.multiimageoperation.AbstractBoofCVMultiImageOperation;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.Field;

public class ReportFieldSubtraction
extends AbstractBoofCVMultiImageOperation {
    private static final long serialVersionUID = 7381673951864996785L;
    protected Field[] m_Fields;

    public String globalInfo() {
        return "For each of the specified report fields, the difference between the value from the first report and the second is calculated. The updated report is output with the first image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "fields", (Object)new Field[0]);
    }

    public void setFields(Field[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public Field[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to create the difference for.";
    }

    public int minNumImagesRequired() {
        return 2;
    }

    public int maxNumImagesRequired() {
        return 2;
    }

    protected void check(BoofCVImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = null;
        for (Field field : this.m_Fields) {
            for (int i = 0; i < images.length; ++i) {
                if (!images[i].hasReport()) {
                    msg = "Image #" + (i + 1) + " has no report attached!";
                    break;
                }
                if (!images[i].getReport().hasValue((AbstractField)field)) {
                    msg = "Image #" + (i + 1) + " does not have field '" + field + "'!";
                    break;
                }
                if (images[i].getReport().getDoubleValue((AbstractField)field) != null) continue;
                msg = "Image #" + (i + 1) + " does not have a numeric value for field '" + field + "'!";
                break;
            }
            if (msg != null) break;
        }
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BoofCVImageContainer[] doProcess(BoofCVImageContainer[] images) {
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)images[0].getClone()};
        for (Field field : this.m_Fields) {
            double diff = images[0].getReport().getDoubleValue((AbstractField)field) - images[1].getReport().getDoubleValue((AbstractField)field);
            result[0].getReport().setValue((AbstractField)field, (Object)diff);
        }
        return result;
    }
}

