/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.struct.image.ImageUInt8;

public class Inverter
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = 8829671646134900700L;

    public String globalInfo() {
        return "Takes a binary image in the BoofCV Unsigned Int 8 format and inverts each pixel. If the image is notbinary behaviour is undefined.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 image = (ImageUInt8)BoofCVHelper.toBoofCVImage(img, BoofCVImageType.UNSIGNED_INT_8);
        BoofCVImageContainer[] result = new BoofCVImageContainer[1];
        byte[] data = image.getData();
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] == 1 ? -1 : 1;
        }
        image.setData(data);
        result[0] = new BoofCVImageContainer();
        result[0].setImage(image);
        return result;
    }
}

