/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.image.BufferedImageHelper;
import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.factory.segmentation.ConfigSlic;
import boofcv.factory.segmentation.FactoryImageSegmentation;
import boofcv.gui.feature.VisualizeRegions;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;

public class SuperPixels
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -6214162210938255035L;
    public static final int R = 0;
    public static final int G = 1;
    public static final int B = 2;
    protected int m_NumSegments;
    protected float m_SpatialWeight;
    protected boolean m_AverageSegments;
    protected boolean m_OutlineSegments;
    protected boolean m_RandomColors;

    public String globalInfo() {
        return "Takes an image and divides it into super pixels.\n\nFor more information see:\nhttp://boofcv.org/index.php?title=Tutorial_Image_Segmentation";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-segments", "numSegments", (Object)100, (Number)1, null);
        this.m_OptionManager.add("spatial-weight", "spatialWeight", (Object)Float.valueOf(200.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("outline-segments", "outlineSegments", (Object)false);
        this.m_OptionManager.add("average-segments", "averageSegments", (Object)false);
        this.m_OptionManager.add("random-colors", "randomColors", (Object)false);
    }

    public void setRandomColors(boolean value) {
        this.m_RandomColors = value;
        this.reset();
    }

    public boolean isRandomColors() {
        return this.m_RandomColors;
    }

    public String randomColorsTipText() {
        return "If enabled, random colors are used.";
    }

    public void setNumSegments(int value) {
        if (this.getOptionManager().isValid("numSegments", (Number)value)) {
            this.m_NumSegments = value;
            this.reset();
        }
    }

    public int getNumSegments() {
        return this.m_NumSegments;
    }

    public String numSegmentsTipText() {
        return "The number of segments to use.";
    }

    public void setSpatialWeight(float value) {
        if (this.getOptionManager().isValid("spatialWeight", (Number)Float.valueOf(value))) {
            this.m_SpatialWeight = value;
            this.reset();
        }
    }

    public float getSpatialWeight() {
        return this.m_SpatialWeight;
    }

    public String spatialWeightTipText() {
        return "The spatial weight.";
    }

    public void setAverageSegments(boolean value) {
        this.m_AverageSegments = value;
        this.reset();
    }

    public boolean isAverageSegments() {
        return this.m_AverageSegments;
    }

    public String averageSegmentsTipText() {
        return "If enabled, segments get averaged.";
    }

    public void setOutlineSegments(boolean value) {
        this.m_OutlineSegments = value;
        this.reset();
    }

    public boolean isOutlineSegments() {
        return this.m_OutlineSegments;
    }

    public String outlineSegmentsTipText() {
        return "If enabled, segments get outlined.";
    }

    protected void averageSegmentColour(ImageSInt32 pixelMap, int numSegments, BufferedImage image) {
        int[] count = new int[numSegments];
        int[][] runningSum = new int[numSegments][4];
        for (int i = 0; i < count.length; ++i) {
            count[i] = 1;
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int segment;
                int n = segment = pixelMap.get(x, y);
                count[n] = count[n] + 1;
                int[] rgb = BufferedImageHelper.split((int)image.getRGB(x, y));
                int[] nArray = runningSum[segment];
                nArray[0] = nArray[0] + rgb[0];
                int[] nArray2 = runningSum[segment];
                nArray2[1] = nArray2[1] + rgb[1];
                int[] nArray3 = runningSum[segment];
                nArray3[2] = nArray3[2] + rgb[2];
            }
        }
        int[] averageRgbForSegment = new int[numSegments];
        for (int segment = 0; segment < numSegments; ++segment) {
            averageRgbForSegment[segment] = BufferedImageHelper.combine((int)(runningSum[segment][0] / count[segment]), (int)(runningSum[segment][1] / count[segment]), (int)(runningSum[segment][2] / count[segment]), (int)255);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int segment = pixelMap.get(x, y);
                image.setRGB(x, y, averageRgbForSegment[segment]);
            }
        }
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{new BoofCVImageContainer()};
        ImageSuperpixels alg = FactoryImageSegmentation.slic((ConfigSlic)new ConfigSlic(this.m_NumSegments, this.m_SpatialWeight), (ImageType)((ImageBase)img.getImage()).getImageType());
        ImageSInt32 output = new ImageSInt32(img.getWidth(), img.getHeight());
        alg.segment((ImageBase)img.getImage(), output);
        BufferedImage image = img.toBufferedImage();
        int numSegments = alg.getTotalSuperpixels();
        if (this.m_AverageSegments) {
            this.averageSegmentColour(output, numSegments, image);
        }
        if (this.m_RandomColors && !this.m_AverageSegments) {
            VisualizeRegions.regions((ImageSInt32)output, (int)numSegments, (BufferedImage)image);
        }
        if (this.m_OutlineSegments) {
            VisualizeRegions.regionBorders((ImageSInt32)output, (int)0xFF0000, (BufferedImage)image);
        }
        result[0].setImage(BoofCVHelper.toBoofCVImage(image));
        result[0].setReport(img.getReport().getClone());
        result[0].getNotes().mergeWith(img.getNotes());
        return result;
    }
}

