/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.ApacheCommonsImageReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.struct.image.ImageSInt16;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractBoofCVTransformerTestCase
extends AdamsTestCase {
    public AbstractBoofCVTransformerTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/boofcv/transformer/data");
    }

    protected BoofCVImageContainer load(String filename) {
        BoofCVImageContainer result = null;
        this.m_TestHelper.copyResourceToTmp(filename);
        ApacheCommonsImageReader reader = new ApacheCommonsImageReader();
        BufferedImageContainer cont = (BufferedImageContainer)reader.read((PlaceholderFile)new TmpFile(filename));
        if (cont != null) {
            result = new BoofCVImageContainer();
            result.setImage((Object)ConvertBufferedImage.convertFromSingle((BufferedImage)cont.toBufferedImage(), null, ImageSInt16.class));
            result.getReport().setStringValue("Filename", new PlaceholderFile(filename).getName());
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected BoofCVImageContainer[] process(BoofCVImageContainer img, AbstractBoofCVTransformer scheme) {
        return (BoofCVImageContainer[])scheme.transform((AbstractImageContainer)img);
    }

    protected boolean save(BoofCVImageContainer data, String filename) {
        TmpFile file = new TmpFile(filename);
        StringBuilder content = new StringBuilder();
        content.append("Image:\n");
        content.append(Utils.flatten((Object[])Utils.breakUp((String)Utils.arrayToString((Object)BufferedImageHelper.getPixelRaster((BufferedImage)data.toBufferedImage())), (int)80), (String)"\n"));
        content.append("\n");
        content.append("Report:\n");
        Report report = data.getReport().getClone();
        report.removeValue((AbstractField)new Field("Filename", DataType.STRING));
        content.append(report);
        content.append("\n");
        content.append("Notes:\n");
        content.append(data.getNotes());
        content.append("\n");
        FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)content, (boolean)false);
        return file.exists();
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractBoofCVTransformer[] getRegressionSetups();

    protected String createOutputFilename(String input, int no, int imgNo) {
        Object result;
        String ext = "-out" + no + "_" + imgNo;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
        }
        result = (String)result + ".txt";
        return result;
    }

    public void testRegression() {
        int n;
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[][] output = new String[input.length][];
        AbstractBoofCVTransformer[] setups = this.getRegressionSetups();
        AbstractBoofCVTransformerTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            BoofCVImageContainer data = this.load(input[i]);
            AbstractBoofCVTransformerTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            BoofCVImageContainer[] processed = this.process(data, setups[i]);
            AbstractBoofCVTransformerTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = new String[processed.length];
            for (n = 0; n < output[i].length; ++n) {
                output[i][n] = this.createOutputFilename(input[i], i, n);
                boolean ok = this.save(processed[n], output[i][n]);
                AbstractBoofCVTransformerTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            }
        }
        ArrayList<TmpFile> outputFiles = new ArrayList<TmpFile>();
        for (i = 0; i < output.length; ++i) {
            for (n = 0; n < output[i].length; ++n) {
                outputFiles.add(new TmpFile(output[i][n]));
            }
        }
        String regression = this.m_Regression.compare((File[])outputFiles.toArray(new TmpFile[outputFiles.size()]));
        AbstractBoofCVTransformerTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            for (n = 0; n < output[i].length; ++n) {
                this.m_TestHelper.deleteFileFromTmp(output[i][n]);
            }
        }
    }
}

