/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.features.AbstractBoofCVFeatureGenerator;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.report.DataType;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.util.ArrayList;
import java.util.List;

public class Otsu
extends AbstractBoofCVFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_Min;
    protected int m_Max;

    public String globalInfo() {
        return "Computes the variance based threshold using Otsu's method from an input image (gray scale; " + ImageUInt8.class.getName() + ").\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Otsu's method");
        result.setValue(TechnicalInformation.Field.HTTP, "https://en.wikipedia.org/wiki/Otsu%27s_method");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "min", (Object)0, (Number)0, null);
        this.m_OptionManager.add("max", "max", (Object)256, (Number)1, null);
    }

    public void setMin(int value) {
        this.m_Min = value;
        this.reset();
    }

    public int getMin() {
        return this.m_Min;
    }

    public String minTipText() {
        return "The minimum value to use in the computation (included).";
    }

    public void setMax(int value) {
        this.m_Max = value;
        this.reset();
    }

    public int getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "The maximum value to use in the computation (excluded).";
    }

    public HeaderDefinition createHeader(BoofCVImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Otsu", DataType.NUMERIC);
        return result;
    }

    public List<Object>[] generateRows(BoofCVImageContainer img) {
        List[] result = new List[]{new ArrayList()};
        ImageBase gray = BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.UNSIGNED_INT_8);
        result[0].add(GThresholdImageOps.computeOtsu((ImageSingleBand)((ImageUInt8)gray), (int)this.m_Min, (int)this.m_Max));
        return result;
    }
}

