/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.multiimageoperation;

import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.multiimageoperation.AbstractBoofCVMultiImageOperation;
import adams.data.image.AbstractImageContainer;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

public class Or
extends AbstractBoofCVMultiImageOperation {
    private static final long serialVersionUID = -167349220127243609L;

    public String globalInfo() {
        return "Performs a logical OR on the binary pixels of the images.\nConverts images automatically to type " + BoofCVImageType.UNSIGNED_INT_8 + ".";
    }

    public int minNumImagesRequired() {
        return 2;
    }

    public int maxNumImagesRequired() {
        return 2;
    }

    protected void check(BoofCVImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions(images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BoofCVImageContainer[] doProcess(BoofCVImageContainer[] images) {
        BoofCVImageContainer[] result = new BoofCVImageContainer[1];
        ImageUInt8 img0 = (ImageUInt8)BoofCVHelper.toBoofCVImage(images[0], BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 img1 = (ImageUInt8)BoofCVHelper.toBoofCVImage(images[1], BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 output = (ImageUInt8)BoofCVHelper.clone((ImageBase)img0);
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                int or = img0.get(x, y) == 0 || img1.get(x, y) == 0 ? 0 : 1;
                output.set(x, y, or);
            }
        }
        result[0] = new BoofCVImageContainer();
        result[0].setImage(output);
        return result;
    }
}

