/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.factory.feature.detect.edge.FactoryEdgeDetectors;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;
import java.util.List;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="http://boofcv.org/index.php?title=Example_Canny_Edge", note="Example code taken from this URL")
public class CannyEdgeDetection
extends AbstractBoofCVTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -465068613851000709L;
    protected int m_BlurRadius;
    protected float m_LowThreshold;
    protected float m_HighThreshold;
    protected ConnectRule m_ConnectRule;
    protected OutputType m_Type;

    public String globalInfo() {
        return "Performs edge detection using the Canny Edge detection algorithm.\nFor more information on the algorithm, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Canny edge detector");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Canny_edge_detector");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("blur-radius", "blurRadius", (Object)2, (Number)1, null);
        this.m_OptionManager.add("type", "type", (Object)OutputType.BINARY_EDGES);
        this.m_OptionManager.add("low-threshold", "lowThreshold", (Object)Float.valueOf(0.1f));
        this.m_OptionManager.add("connect-rule", "connectRule", (Object)ConnectRule.EIGHT);
        this.m_OptionManager.add("high-threshold", "highThreshold", (Object)Float.valueOf(0.3f));
    }

    public void setBlurRadius(int value) {
        if (this.getOptionManager().isValid("blurRadius", (Number)value)) {
            this.m_BlurRadius = value;
            this.reset();
        }
    }

    public int getBlurRadius() {
        return this.m_BlurRadius;
    }

    public String blurRadiusTipText() {
        return "The radius to use for the gaussian blur.";
    }

    public void setType(OutputType value) {
        this.m_Type = value;
        this.reset();
    }

    public OutputType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of output to generate.";
    }

    public void setLowThreshold(float value) {
        this.m_LowThreshold = value;
        this.reset();
    }

    public float getLowThreshold() {
        return this.m_LowThreshold;
    }

    public String lowThresholdTipText() {
        return "The low threshold to use.";
    }

    public void setHighThreshold(float value) {
        this.m_HighThreshold = value;
        this.reset();
    }

    public float getHighThreshold() {
        return this.m_HighThreshold;
    }

    public String highThresholdTipText() {
        return "The high threshold to use.";
    }

    public void setConnectRule(ConnectRule value) {
        this.m_ConnectRule = value;
        this.reset();
    }

    public ConnectRule getConnectRule() {
        return this.m_ConnectRule;
    }

    public String connectRuleTipText() {
        return "The connect rule to apply.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        BufferedImage rendered;
        ImageUInt8 gray = (ImageUInt8)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 edgeImage = new ImageUInt8(gray.width, gray.height);
        CannyEdge canny = FactoryEdgeDetectors.canny((int)this.m_BlurRadius, (boolean)true, (boolean)true, ImageUInt8.class, ImageSInt16.class);
        canny.process((ImageSingleBand)gray, this.m_LowThreshold, this.m_HighThreshold, edgeImage);
        List edgeContours = canny.getContours();
        List contours = BinaryImageOps.contour((ImageUInt8)edgeImage, (ConnectRule)this.m_ConnectRule, null);
        switch (this.m_Type) {
            case BINARY_EDGES: {
                rendered = VisualizeBinaryData.renderBinary((ImageUInt8)edgeImage, null);
                break;
            }
            case CONTOUR: {
                rendered = VisualizeBinaryData.renderContours((List)edgeContours, null, (int)gray.width, (int)gray.height, null);
                break;
            }
            case TRACE_GRAPH: {
                rendered = VisualizeBinaryData.renderExternal((List)contours, null, (int)gray.width, (int)gray.height, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + this.m_Type);
            }
        }
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(ConvertBufferedImage.convertFrom((BufferedImage)rendered, (ImageFloat32)null));
        return result;
    }

    public static enum OutputType {
        BINARY_EDGES,
        TRACE_GRAPH,
        CONTOUR;

    }
}

