/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.BoofCVImageWriter;
import adams.data.io.output.ImageWriter;
import boofcv.io.image.UtilImageIO;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;

public class BoofCVImageReader
extends AbstractImageReader<BoofCVImageContainer> {
    private static final long serialVersionUID = 5347100846354068540L;
    protected String[] m_FormatExtensions;

    public String globalInfo() {
        return "BoofCV image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\nFor more information see:\nhttp://boofcv.org/";
    }

    protected void initialize() {
        super.initialize();
        ArrayList<String> formats = new ArrayList<String>();
        formats.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
        if (!formats.contains("ppm")) {
            formats.add("ppm");
        }
        if (!formats.contains("pgm")) {
            formats.add("pgm");
        }
        Collections.sort(formats);
        this.m_FormatExtensions = formats.toArray(new String[formats.size()]);
    }

    public String getFormatDescription() {
        return "BoofCV";
    }

    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    public ImageWriter getCorrespondingWriter() {
        return new BoofCVImageWriter();
    }

    protected BoofCVImageContainer doRead(PlaceholderFile file) {
        BoofCVImageContainer result = null;
        BufferedImage image = UtilImageIO.loadImage((String)file.getAbsolutePath());
        if (image != null) {
            result = new BoofCVImageContainer();
            result.setImage(BoofCVHelper.toBoofCVImage(image));
        }
        return result;
    }
}

