/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageType;
import adams.data.image.AbstractImageContainer;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import boofcv.abst.feature.detect.line.DetectLineSegmentsGridRansac;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.line.LineSegment2D_F32;
import java.util.List;

@MixedCopyright(copyright="2011-2012 Peter Abeles", license=License.APACHE2, note="Example code taken from here http://boofcv.org/index.php?title=Example_Detect_Lines")
public class BoofCVDetectLineSegments
extends AbstractTransformer {
    private static final long serialVersionUID = 2784091483353536513L;
    protected int m_RegionSize;
    protected double m_ThresholdEdge;
    protected double m_ThresholdAngle;
    protected boolean m_ConnectLines;

    public String globalInfo() {
        return "Detects line segments in images (line RANSAC).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("region-size", "regionSize", (Object)40, (Number)0, null);
        this.m_OptionManager.add("threshold-edge", "thresholdEdge", (Object)30.0, (Number)0.0, null);
        this.m_OptionManager.add("threshold-angle", "thresholdAngle", (Object)2.36);
        this.m_OptionManager.add("connect-lines", "connectLines", (Object)false);
    }

    public void setRegionSize(int value) {
        if (value >= 0) {
            this.m_RegionSize = value;
            this.reset();
        } else {
            this.getLogger().warning("Local max radius must be at least 0, provided: " + value);
        }
    }

    public int getRegionSize() {
        return this.m_RegionSize;
    }

    public String regionSizeTipText() {
        return "The size of the region.";
    }

    public void setThresholdEdge(double value) {
        if (value >= 0.0) {
            this.m_ThresholdEdge = value;
            this.reset();
        } else {
            this.getLogger().warning("Edge threshold must be at least 0, provided: " + value);
        }
    }

    public double getThresholdEdge() {
        return this.m_ThresholdEdge;
    }

    public String thresholdEdgeTipText() {
        return "The edge threshold to use.";
    }

    public void setThresholdAngle(double value) {
        this.m_ThresholdAngle = value;
        this.reset();
    }

    public double getThresholdAngle() {
        return this.m_ThresholdAngle;
    }

    public String thresholdAngleTipText() {
        return "The angle threshold in radians to use.";
    }

    public void setConnectLines(boolean value) {
        this.m_ConnectLines = value;
        this.reset();
    }

    public boolean getConnectLines() {
        return this.m_ConnectLines;
    }

    public String connectLinesTipText() {
        return "Whether lines should be connected and optimized.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
            ImageFloat32 input = (ImageFloat32)BoofCVHelper.toBoofCVImage(cont, BoofCVImageType.FLOAT_32);
            DetectLineSegmentsGridRansac detector = FactoryDetectLineAlgs.lineRansac((int)this.m_RegionSize, (double)this.m_ThresholdEdge, (double)this.m_ThresholdAngle, (boolean)this.m_ConnectLines, ImageFloat32.class, ImageFloat32.class);
            List found = detector.detect((ImageSingleBand)input);
            DefaultSpreadSheet sheet = new DefaultSpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("I").setContent("Index");
            row.addCell("AX").setContent("A.X");
            row.addCell("AY").setContent("A.Y");
            row.addCell("BX").setContent("B.X");
            row.addCell("BY").setContent("B.Y");
            for (LineSegment2D_F32 line : found) {
                row = sheet.addRow();
                row.addCell("I").setContent(Integer.valueOf(sheet.getRowCount()));
                row.addCell("AX").setContent(Float.valueOf(line.a.x));
                row.addCell("AY").setContent(Float.valueOf(line.a.y));
                row.addCell("BX").setContent(Float.valueOf(line.b.x));
                row.addCell("BY").setContent(Float.valueOf(line.b.y));
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to detect line segments", e);
        }
        return result;
    }
}

