/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.annotator;

import adams.gui.core.KeyUtils;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.object.annotator.AbstractAnnotator;
import adams.gui.visualization.object.tools.DEXTR;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;

public class DEXTRMarkers
extends AbstractAnnotator {
    private static final long serialVersionUID = -5432370868809862158L;
    protected Shape m_Shape;
    protected Color m_Color;
    protected int m_Extent;
    protected List<Point> m_Points;
    protected MouseListener m_MouseListener;
    protected KeyListener m_KeyListener;
    protected DEXTR m_Tool;

    public String globalInfo() {
        return "Annotator plugin that works only in conjunction with the DEXTR tool.\nLeft-click to add an extreme point, CTRL and left-click clears the points.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("shape", "shape", (Object)Shape.CIRCLE);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("extent", "extent", (Object)7, (Number)1, null);
    }

    protected void initialize() {
        super.initialize();
        this.m_Selecting = true;
        this.m_Points = new ArrayList<Point>();
        this.m_MouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick((MouseEvent)e) && KeyUtils.isCtrlDown((int)e.getModifiersEx())) {
                    DEXTRMarkers.this.m_Points.clear();
                    e.consume();
                    DEXTRMarkers.this.getOwner().annotationsChanged((Object)this);
                } else if (MouseUtils.isLeftClick((MouseEvent)e) && MouseUtils.hasNoModifierKey((MouseEvent)e)) {
                    DEXTRMarkers.this.m_Points.add(new Point((int)((double)e.getX() / DEXTRMarkers.this.getOwner().getActualZoom()), (int)((double)e.getY() / DEXTRMarkers.this.getOwner().getActualZoom())));
                    e.consume();
                    DEXTRMarkers.this.getOwner().annotationsChanged((Object)this);
                    if (!DEXTRMarkers.this.getOwner().getCanvas().hasFocus()) {
                        DEXTRMarkers.this.getOwner().getCanvas().requestFocus();
                    }
                }
                super.mouseClicked(e);
            }
        };
        this.m_KeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && DEXTRMarkers.this.m_Tool != null && DEXTRMarkers.this.m_Points.size() == 4) {
                    e.consume();
                    DEXTRMarkers.this.m_Tool.setPoints(DEXTRMarkers.this.m_Points);
                    DEXTRMarkers.this.m_Points.clear();
                    DEXTRMarkers.this.getOwner().annotationsChanged((Object)this);
                    DEXTRMarkers.this.m_Tool.sendData();
                }
                super.keyPressed(e);
            }
        };
    }

    public void setShape(Shape value) {
        this.m_Shape = value;
        this.reset();
    }

    public Shape getShape() {
        return this.m_Shape;
    }

    public String shapeTipText() {
        return "The shape for the point markers.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for drawing the point markers.";
    }

    public void setExtent(int value) {
        this.m_Extent = value;
        this.reset();
    }

    public int getExtent() {
        return this.m_Extent;
    }

    public String extentTipText() {
        return "The size of the markers.";
    }

    public void setTool(DEXTR value) {
        this.m_Tool = value;
    }

    public DEXTR getTool() {
        return this.m_Tool;
    }

    protected void doInstall() {
        this.getOwner().getCanvas().addMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().addKeyListener(this.m_KeyListener);
    }

    protected void doUninstall() {
        this.getOwner().getCanvas().removeMouseListener(this.m_MouseListener);
        this.getOwner().getCanvas().removeKeyListener(this.m_KeyListener);
    }

    protected void doPaintSelection(Graphics g) {
        if (this.m_Points.size() == 0) {
            return;
        }
        g.setColor(this.m_Color);
        int prevX = 0;
        int prevY = 0;
        for (Point p : this.m_Points) {
            int currX = (int)p.getX();
            int currY = (int)p.getY();
            if (!(Math.sqrt(Math.pow(currX - prevX, 2.0) + Math.pow(currY - prevY, 2.0)) > (double)(this.m_Extent * 2))) continue;
            if (this.m_Shape == Shape.BOX) {
                g.drawRect(currX - this.m_Extent / 2, currY - this.m_Extent / 2, this.m_Extent - 1, this.m_Extent - 1);
            } else if (this.m_Shape == Shape.CIRCLE) {
                g.drawArc(currX - this.m_Extent / 2, currY - this.m_Extent / 2, this.m_Extent - 1, this.m_Extent - 1, 0, 360);
            } else if (this.m_Shape == Shape.TRIANGLE) {
                int[] x = new int[3];
                int[] y = new int[3];
                x[0] = currX - this.m_Extent / 2;
                y[0] = currY + this.m_Extent / 2;
                x[1] = x[0] + this.m_Extent;
                y[1] = y[0];
                x[2] = currX;
                y[2] = y[0] - this.m_Extent;
                g.drawPolygon(x, y, 3);
            }
            prevX = currX;
            prevY = currY;
        }
    }

    public static enum Shape {
        BOX,
        CIRCLE,
        TRIANGLE;

    }
}

