/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.tools;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.base.BaseHostname;
import adams.core.base.BaseObject;
import adams.core.logging.LoggingSupporter;
import adams.data.redis.RedisDataType;
import adams.gui.core.BaseObjectTextField;
import adams.gui.core.BaseTextField;
import adams.gui.core.CheckedTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.visualization.object.tools.AbstractToolWithParameterPanel;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.awt.Component;
import javax.swing.SwingWorker;

public abstract class AbstractRedisTool<O, I>
extends AbstractToolWithParameterPanel {
    private static final long serialVersionUID = 8374950649752446530L;
    protected BaseObjectTextField<BaseHostname> m_TextRedisHost;
    protected BaseTextField m_TextRedisSend;
    protected BaseTextField m_TextRedisReceive;
    protected NumberTextField m_TextRedisTimeout;
    protected String m_RedisHost;
    protected int m_RedisPort;
    protected int m_RedisDB;
    protected String m_RedisSend;
    protected String m_RedisReceive;
    protected int m_RedisTimeout;
    protected I m_ReceivedData;
    protected transient RedisClient m_Client;
    protected transient StatefulRedisPubSubConnection m_PubSubConnection;
    protected transient StatefulRedisConnection m_Connection;
    protected transient RedisPubSubListener m_PubSubListener;

    protected String checkBeforeApply() {
        String result = super.checkBeforeApply();
        if (result == null) {
            if (this.m_TextRedisSend.getText().trim().isEmpty()) {
                result = "'Send' channel is empty!";
            } else if (this.m_TextRedisReceive.getText().trim().isEmpty()) {
                result = "'Receive' channel is empty!";
            }
        }
        return result;
    }

    protected void retrieveParameters() {
        this.m_RedisHost = ((BaseHostname)this.m_TextRedisHost.getObject()).hostnameValue();
        this.m_RedisPort = ((BaseHostname)this.m_TextRedisHost.getObject()).portValue(6379);
        this.m_RedisDB = 0;
        this.m_RedisSend = this.m_TextRedisSend.getText();
        this.m_RedisReceive = this.m_TextRedisReceive.getText();
        this.m_RedisTimeout = this.m_TextRedisTimeout.getValue().intValue();
    }

    protected void doApply() {
        this.retrieveParameters();
        if (this.m_Client != null) {
            this.m_Client.shutdown();
            this.m_Client = null;
        }
        try {
            this.m_Client = RedisClient.create((RedisURI)RedisURI.Builder.redis((String)this.m_RedisHost, (int)this.m_RedisPort).withDatabase(this.m_RedisDB).build());
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getCanvas(), (String)("Failed to create Redis client: " + this.m_RedisHost + ":" + this.m_RedisPort + "/" + this.m_RedisDB), (Throwable)e);
        }
    }

    protected abstract String getSendChannel();

    protected abstract String getReceiveChannel();

    protected int getDefaultTimeout() {
        return 2000;
    }

    protected void addOptions(ParameterPanel paramPanel) {
        this.m_TextRedisHost = new BaseObjectTextField((BaseObject)new BaseHostname("localhost:6379"));
        this.m_TextRedisHost.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter("Redis host", this.m_TextRedisHost);
        this.m_TextRedisSend = new BaseTextField(this.getSendChannel(), 10);
        this.m_TextRedisSend.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter("- Send", (Component)this.m_TextRedisSend);
        this.m_TextRedisReceive = new BaseTextField(this.getReceiveChannel(), 10);
        this.m_TextRedisReceive.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter("- Receive", (Component)this.m_TextRedisReceive);
        this.m_TextRedisTimeout = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextRedisTimeout.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)1, null, (Number)this.getDefaultTimeout()));
        this.m_TextRedisTimeout.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter(" - Timeout (msec)", (Component)this.m_TextRedisTimeout);
    }

    protected abstract RedisDataType getSendType();

    protected abstract RedisDataType getReceiveType();

    protected RedisPubSubListener<String, String> newStringListener() {
        return new RedisPubSubListener<String, String>(){

            public void message(String channel, String message) {
                AbstractRedisTool.this.m_ReceivedData = message;
                AbstractRedisTool.this.m_PubSubConnection.removeListener(AbstractRedisTool.this.m_PubSubListener);
                AbstractRedisTool.this.m_PubSubConnection.async().unsubscribe(new Object[]{AbstractRedisTool.this.m_RedisReceive});
                AbstractRedisTool.this.m_PubSubConnection = null;
                AbstractRedisTool.this.m_PubSubListener = null;
            }

            public void message(String pattern, String channel, String message) {
                this.message(channel, message);
            }

            public void subscribed(String channel, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Subscribed to channel: " + channel);
                }
            }

            public void psubscribed(String pattern, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Subscribed to pattern: " + pattern);
                }
            }

            public void unsubscribed(String channel, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Unsubscribed from channel: " + channel);
                }
            }

            public void punsubscribed(String pattern, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Unsubscribed from pattern: " + pattern);
                }
            }
        };
    }

    protected RedisPubSubListener<byte[], byte[]> newBytesListener() {
        return new RedisPubSubListener<byte[], byte[]>(){

            public void message(byte[] channel, byte[] message) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Message on channel '" + new String(channel) + "': " + new String(message));
                }
                AbstractRedisTool.this.m_ReceivedData = message;
                AbstractRedisTool.this.m_PubSubConnection.removeListener(AbstractRedisTool.this.m_PubSubListener);
                AbstractRedisTool.this.m_PubSubConnection.async().unsubscribe(new Object[]{AbstractRedisTool.this.m_RedisReceive.getBytes()});
                AbstractRedisTool.this.m_PubSubConnection = null;
                AbstractRedisTool.this.m_PubSubListener = null;
            }

            public void message(byte[] pattern, byte[] channel, byte[] message) {
                this.message(channel, message);
            }

            public void subscribed(byte[] channel, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Subscribed to channel: " + new String(channel));
                }
            }

            public void psubscribed(byte[] pattern, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Subscribed to pattern: " + new String(pattern));
                }
            }

            public void unsubscribed(byte[] channel, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Unsubscribed from channel: " + new String(channel));
                }
            }

            public void punsubscribed(byte[] pattern, long count) {
                if (AbstractRedisTool.this.isLoggingEnabled()) {
                    AbstractRedisTool.this.getLogger().info("Unsubscribed from pattern: " + new String(pattern));
                }
            }
        };
    }

    protected abstract O assembleSendData(MessageCollection var1);

    protected abstract void parseReceivedData(I var1, MessageCollection var2);

    protected void finishedRequest() {
        this.m_ReceivedData = null;
    }

    public void sendData() {
        this.m_ReceivedData = null;
        final MessageCollection errors = new MessageCollection();
        final O out = this.assembleSendData(errors);
        if (out == null) {
            if (errors.isEmpty()) {
                GUIHelper.showErrorMessage((Component)this.getCanvas(), (String)"Failed to generate data to send to Redis!");
            } else {
                GUIHelper.showErrorMessage((Component)this.getCanvas(), (String)("Failed to generate data to send to Redis:\n" + errors));
            }
            return;
        }
        switch (this.getSendType()) {
            case STRING: {
                if (out instanceof String) break;
                throw new IllegalStateException("Output data is not of type String, but: " + Utils.classToString(out));
            }
            case BYTE_ARRAY: {
                if (out instanceof byte[]) break;
                throw new IllegalStateException("Output data is not of type byte[], but: " + Utils.classToString(out));
            }
            default: {
                throw new IllegalStateException("Unhandled send data type: " + this.getSendType());
            }
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                switch (AbstractRedisTool.this.getReceiveType()) {
                    case STRING: {
                        AbstractRedisTool.this.m_PubSubListener = AbstractRedisTool.this.newStringListener();
                        AbstractRedisTool.this.m_PubSubConnection = AbstractRedisTool.this.m_Client.connectPubSub((RedisCodec)StringCodec.UTF8);
                        AbstractRedisTool.this.m_PubSubConnection.addListener(AbstractRedisTool.this.m_PubSubListener);
                        AbstractRedisTool.this.m_PubSubConnection.async().subscribe(new Object[]{AbstractRedisTool.this.m_RedisReceive});
                        break;
                    }
                    case BYTE_ARRAY: {
                        AbstractRedisTool.this.m_PubSubListener = AbstractRedisTool.this.newBytesListener();
                        AbstractRedisTool.this.m_PubSubConnection = AbstractRedisTool.this.m_Client.connectPubSub((RedisCodec)new ByteArrayCodec());
                        AbstractRedisTool.this.m_PubSubConnection.addListener(AbstractRedisTool.this.m_PubSubListener);
                        AbstractRedisTool.this.m_PubSubConnection.async().subscribe(new Object[]{AbstractRedisTool.this.m_RedisReceive.getBytes()});
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled receive data type: " + AbstractRedisTool.this.getReceiveType());
                    }
                }
                switch (AbstractRedisTool.this.getSendType()) {
                    case STRING: {
                        AbstractRedisTool.this.m_Connection = AbstractRedisTool.this.m_Client.connect((RedisCodec)StringCodec.UTF8);
                        AbstractRedisTool.this.m_Connection.async().publish((Object)AbstractRedisTool.this.m_RedisSend, out);
                        break;
                    }
                    case BYTE_ARRAY: {
                        AbstractRedisTool.this.m_Connection = AbstractRedisTool.this.m_Client.connect((RedisCodec)new ByteArrayCodec());
                        AbstractRedisTool.this.m_Connection.async().publish((Object)AbstractRedisTool.this.m_RedisSend.getBytes(), out);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled send data type: " + AbstractRedisTool.this.getSendType());
                    }
                }
                errors.clear();
                long start = System.currentTimeMillis();
                while (AbstractRedisTool.this.m_ReceivedData == null && System.currentTimeMillis() - start < (long)AbstractRedisTool.this.m_RedisTimeout) {
                    Utils.wait((LoggingSupporter)AbstractRedisTool.this, (int)100, (int)100);
                }
                if (AbstractRedisTool.this.m_ReceivedData != null) {
                    switch (AbstractRedisTool.this.getReceiveType()) {
                        case STRING: {
                            if (AbstractRedisTool.this.m_ReceivedData instanceof String) break;
                            throw new IllegalStateException("Input data is not of type String, but: " + Utils.classToString(AbstractRedisTool.this.m_ReceivedData));
                        }
                        case BYTE_ARRAY: {
                            if (AbstractRedisTool.this.m_ReceivedData instanceof byte[]) break;
                            throw new IllegalStateException("Input data is not of type byte[], but: " + Utils.classToString(AbstractRedisTool.this.m_ReceivedData));
                        }
                        default: {
                            throw new IllegalStateException("Unhandled send data type: " + AbstractRedisTool.this.getReceiveType());
                        }
                    }
                    AbstractRedisTool.this.parseReceivedData(AbstractRedisTool.this.m_ReceivedData, errors);
                    if (!errors.isEmpty()) {
                        GUIHelper.showErrorMessage((Component)AbstractRedisTool.this.getCanvas(), (String)errors.toString());
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                AbstractRedisTool.this.finishedRequest();
            }
        };
        worker.execute();
    }

    public void update() {
        super.update();
        this.m_ReceivedData = null;
    }

    public void cleanUp() {
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
        if (this.m_PubSubConnection != null) {
            if (this.m_PubSubListener != null) {
                this.m_PubSubConnection.removeListener(this.m_PubSubListener);
            }
            switch (this.getReceiveType()) {
                case STRING: {
                    this.m_PubSubConnection.async().unsubscribe(new Object[]{this.m_RedisReceive});
                    break;
                }
                case BYTE_ARRAY: {
                    this.m_PubSubConnection.async().unsubscribe(new Object[]{this.m_RedisReceive.getBytes()});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled receive data type: " + this.getReceiveType());
                }
            }
            this.m_PubSubConnection = null;
            this.m_PubSubListener = null;
        }
        if (this.m_Client != null) {
            this.m_Client.shutdown();
            this.m_Client = null;
        }
        super.cleanUp();
    }
}

