/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.tools;

import adams.core.MessageCollection;
import adams.data.image.BufferedImageHelper;
import adams.data.redis.RedisDataType;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import adams.gui.chooser.ColorChooserPanel;
import adams.gui.core.CheckedTextField;
import adams.gui.core.ImageManager;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.visualization.object.annotator.AbstractAnnotator;
import adams.gui.visualization.object.annotator.DEXTRMarkers;
import adams.gui.visualization.object.tools.AbstractRedisTool;
import adams.gui.visualization.object.tools.ToolKeyAdapter;
import adams.gui.visualization.object.tools.ToolMouseAdapter;
import adams.gui.visualization.object.tools.ToolMouseMotionAdapter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.swing.Icon;
import opex4j.Polygon;

public class DEXTR
extends AbstractRedisTool<String, String> {
    private static final long serialVersionUID = 8374950649752446530L;
    protected NumberTextField m_TextMarkerSize;
    protected ColorChooserPanel m_PanelColor;
    protected NumberTextField m_TextMinObjectSize;
    protected NumberTextField m_TextMaxObjectSize;
    protected int m_MarkerSize;
    protected Color m_MarkerColor;
    protected int m_MinObjectSize;
    protected int m_MaxObjectSize;
    protected transient String m_BaseImageBase64;
    protected List<Point> m_Points;
    protected DEXTRMarkers m_Annotator;

    public String globalInfo() {
        return "After connecting to the Redis server, click on four extreme points with the left mouse button and then press ENTER to have a shape detected.\nLeft-Click while holding CTRL to reset the selected points.\nCommunicates with a DEXTR docker container using Redis.\n\nMore information:\nhttps://github.com/waikato-datamining/pytorch/tree/master/dextr";
    }

    protected void initialize() {
        super.initialize();
        this.m_Annotator = new DEXTRMarkers();
        this.m_Annotator.setTool(this);
        this.m_MinObjectSize = -1;
        this.m_MaxObjectSize = -1;
    }

    public String getName() {
        return "DEXTR";
    }

    public Icon getIcon() {
        return ImageManager.getIcon((String)"dextr.png");
    }

    protected Cursor createCursor() {
        if (this.m_Client == null) {
            return Cursor.getPredefinedCursor(0);
        }
        return Cursor.getPredefinedCursor(1);
    }

    protected ToolMouseAdapter createMouseListener() {
        return null;
    }

    protected ToolMouseMotionAdapter createMouseMotionListener() {
        return null;
    }

    protected ToolKeyAdapter createKeyListener() {
        return null;
    }

    @Override
    protected String checkBeforeApply() {
        Object result = super.checkBeforeApply();
        if (result == null) {
            int min = this.m_TextMinObjectSize.getValue().intValue();
            int max = this.m_TextMaxObjectSize.getValue().intValue();
            if (min > 0 && max > 0 && max <= min) {
                result = "Maximum object size must be larger than minimum size, but: min=" + min + " and max=" + max;
            }
        }
        return result;
    }

    @Override
    protected void retrieveParameters() {
        super.retrieveParameters();
        this.m_MarkerSize = this.m_TextMarkerSize.getValue().intValue();
        this.m_MarkerColor = (Color)this.m_PanelColor.getCurrent();
        this.m_MinObjectSize = this.m_TextMinObjectSize.getValue().intValue();
        this.m_MaxObjectSize = this.m_TextMaxObjectSize.getValue().intValue();
        this.m_Annotator.setColor(this.m_MarkerColor);
        this.m_Annotator.setExtent(this.m_MarkerSize);
    }

    @Override
    protected String getSendChannel() {
        return "dextr_in";
    }

    @Override
    protected String getReceiveChannel() {
        return "dextr_out";
    }

    @Override
    protected void addOptions(ParameterPanel paramPanel) {
        super.addOptions(paramPanel);
        this.m_TextMarkerSize = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMarkerSize.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)1, null, (Number)this.m_Annotator.getExtent()));
        this.m_TextMarkerSize.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter("Marker size", (Component)this.m_TextMarkerSize);
        this.m_PanelColor = new ColorChooserPanel(this.m_Annotator.getColor());
        paramPanel.addParameter("- color", (Component)this.m_PanelColor);
        this.m_TextMinObjectSize = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMinObjectSize.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)-1, null, (Number)this.m_MinObjectSize));
        this.m_TextMinObjectSize.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        this.m_TextMinObjectSize.setToolTipText("The minimum object size; fulfilled if either width or height at least this amount; ignored if <1");
        paramPanel.addParameter("Min. object size", (Component)this.m_TextMinObjectSize);
        this.m_TextMaxObjectSize = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMaxObjectSize.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)-1, null, (Number)this.m_MaxObjectSize));
        this.m_TextMaxObjectSize.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        this.m_TextMaxObjectSize.setToolTipText("The maximum object size; fulfilled if either width or height at most this amount; ignored if <1");
        paramPanel.addParameter("Max. object size", (Component)this.m_TextMaxObjectSize);
    }

    @Override
    protected RedisDataType getSendType() {
        return RedisDataType.STRING;
    }

    @Override
    protected RedisDataType getReceiveType() {
        return RedisDataType.STRING;
    }

    public void setPoints(List<Point> value) {
        this.m_Points = value != null ? new ArrayList<Point>(value) : null;
    }

    public List<Point> getPoints() {
        return this.m_Points;
    }

    @Override
    protected String assembleSendData(MessageCollection errors) {
        if (this.m_Points == null) {
            errors.add("No extreme points provided!");
            return null;
        }
        if (this.m_Points.size() != 4) {
            errors.add("Expected four extreme points but received: " + this.m_Points.size());
            return null;
        }
        JsonObject result = new JsonObject();
        if (this.m_BaseImageBase64 == null) {
            byte[] bytes = BufferedImageHelper.toBytes((BufferedImage)this.getCanvas().getImage(), (String)"JPG", (MessageCollection)errors);
            if (bytes != null) {
                this.m_BaseImageBase64 = Base64.getEncoder().encodeToString(bytes);
            } else {
                return null;
            }
        }
        result.addProperty("image", this.m_BaseImageBase64);
        JsonArray points = new JsonArray();
        for (Point p : this.getPoints()) {
            JsonArray coords = new JsonArray();
            coords.add((Number)p.getX());
            coords.add((Number)p.getY());
            points.add((JsonElement)coords);
        }
        result.add("points", (JsonElement)points);
        return result.toString();
    }

    @Override
    protected void parseReceivedData(String data, MessageCollection errors) {
        if (data == null) {
            return;
        }
        JsonObject json = (JsonObject)JsonParser.parseString((String)data);
        JsonArray contours = json.get("contours").getAsJsonArray();
        LocatedObjects lobjs = new LocatedObjects(this.getCanvas().getOwner().getObjects());
        for (int i = 0; i < contours.size(); ++i) {
            JsonArray contour = contours.get(i).getAsJsonArray();
            ArrayList<Point> points = new ArrayList<Point>();
            for (int n = 0; n < contour.size(); ++n) {
                JsonArray coords = contour.get(n).getAsJsonArray();
                points.add(new Point((int)coords.get(0).getAsDouble(), (int)coords.get(1).getAsDouble()));
            }
            Polygon poly = new Polygon(points);
            if (this.m_MinObjectSize > 0 || this.m_MaxObjectSize > 0) {
                Rectangle rect = poly.toBBox().toRectangle();
                if (this.m_MinObjectSize > 0 && rect.width < this.m_MinObjectSize && rect.height < this.m_MinObjectSize || this.m_MaxObjectSize > 0 && rect.width > this.m_MaxObjectSize && rect.height > this.m_MaxObjectSize) continue;
            }
            LocatedObject lobj = new LocatedObject(null, poly.toBBox().toRectangle());
            lobj.setPolygon(poly.toPolygon());
            lobjs.add((Object)lobj);
        }
        String prefix = "Object.";
        if (this.getCanvas().getOwner().getAnnotator() instanceof ObjectPrefixHandler) {
            prefix = ((ObjectPrefixHandler)this.getCanvas().getOwner().getAnnotator()).getPrefix();
        }
        Report report = lobjs.toReport(prefix);
        this.getCanvas().getOwner().addUndoPoint("DEXTR predictions");
        this.getCanvas().getOwner().setReport(report);
        this.getCanvas().getOwner().annotationsChanged((Object)this);
    }

    @Override
    protected void finishedRequest() {
        super.finishedRequest();
        this.m_Points = null;
    }

    public void activate() {
        super.activate();
        this.getCanvas().getOwner().setAnnotator((AbstractAnnotator)this.m_Annotator);
    }
}

