/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.object.tools;

import adams.core.MessageCollection;
import adams.core.Shortening;
import adams.data.image.BufferedImageHelper;
import adams.data.redis.RedisDataType;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.ObjectPrefixHandler;
import adams.gui.core.ImageManager;
import adams.gui.core.KeyUtils;
import adams.gui.core.MouseUtils;
import adams.gui.visualization.object.tools.AbstractRedisTool;
import adams.gui.visualization.object.tools.Tool;
import adams.gui.visualization.object.tools.ToolMouseAdapter;
import adams.gui.visualization.object.tools.ToolMouseMotionAdapter;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import opex4j.ObjectPrediction;
import opex4j.ObjectPredictions;

public class OPEX
extends AbstractRedisTool<byte[], byte[]> {
    private static final long serialVersionUID = -6810912012034001551L;

    public String globalInfo() {
        return "Sends the image to Redis and expects object predictions in OPEX back.\nClick left while holding the SHIFT key to send the data and obtain predictions.";
    }

    public String getName() {
        return "OPEX";
    }

    public Icon getIcon() {
        return ImageManager.getIcon((String)"opex.png");
    }

    protected Cursor createCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    protected ToolMouseAdapter createMouseListener() {
        return new ToolMouseAdapter((Tool)this){

            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick((MouseEvent)e) && KeyUtils.isShiftDown((int)e.getModifiersEx())) {
                    e.consume();
                    OPEX.this.sendData();
                }
                super.mouseClicked(e);
            }
        };
    }

    protected ToolMouseMotionAdapter createMouseMotionListener() {
        return null;
    }

    @Override
    protected RedisDataType getSendType() {
        return RedisDataType.BYTE_ARRAY;
    }

    @Override
    protected RedisDataType getReceiveType() {
        return RedisDataType.BYTE_ARRAY;
    }

    @Override
    protected String getSendChannel() {
        return "opex_in";
    }

    @Override
    protected String getReceiveChannel() {
        return "opex_out";
    }

    @Override
    protected byte[] assembleSendData(MessageCollection errors) {
        return BufferedImageHelper.toBytes((BufferedImage)this.getCanvas().getImage(), (String)"JPG", (MessageCollection)errors);
    }

    @Override
    protected void parseReceivedData(byte[] data, MessageCollection errors) {
        String json = new String(data);
        ObjectPredictions preds = null;
        try {
            preds = ObjectPredictions.newInstance((String)json);
        }
        catch (Exception e) {
            errors.add("Failed to parse received predictions: " + Shortening.shortenStart((String)json, (int)100), (Throwable)e);
        }
        if (preds == null) {
            return;
        }
        LocatedObjects lobjs = new LocatedObjects();
        for (ObjectPrediction pred : preds.getObjects()) {
            LocatedObject lobj = new LocatedObject(pred.getBBox().toRectangle());
            if (pred.getPolygon().size() > 4) {
                lobj.setPolygon(pred.getPolygon().toPolygon());
            }
            lobj.getMetaData().putAll(pred.getMeta());
            lobj.getMetaData().put("type", pred.getLabel());
            if (pred.getScore() != null) {
                lobj.getMetaData().put("score", pred.getScore());
            }
            lobjs.add((Object)lobj);
        }
        String prefix = "Object.";
        if (this.getCanvas().getOwner().getAnnotator() instanceof ObjectPrefixHandler) {
            prefix = ((ObjectPrefixHandler)this.getCanvas().getOwner().getAnnotator()).getPrefix();
        }
        Report report = lobjs.toReport(prefix);
        this.getCanvas().getOwner().addUndoPoint("OPEX predictions");
        this.getCanvas().getOwner().setReport(report);
        this.getCanvas().getOwner().annotationsChanged((Object)this);
    }
}

