/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.segmentation.tool;

import adams.core.MessageCollection;
import adams.data.image.BufferedImageHelper;
import adams.data.redis.RedisDataType;
import adams.data.statistics.StatUtils;
import adams.gui.chooser.ColorChooserPanel;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.CheckedTextField;
import adams.gui.core.ImageManager;
import adams.gui.core.KeyUtils;
import adams.gui.core.MouseUtils;
import adams.gui.core.NumberTextField;
import adams.gui.core.ParameterPanel;
import adams.gui.visualization.segmentation.ImageUtils;
import adams.gui.visualization.segmentation.tool.AbstractRedisTool;
import adams.gui.visualization.segmentation.tool.Tool;
import adams.gui.visualization.segmentation.tool.ToolKeyAdapter;
import adams.gui.visualization.segmentation.tool.ToolMouseAdapter;
import adams.gui.visualization.segmentation.tool.ToolMouseMotionAdapter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Base64;
import javax.swing.Icon;

public class SAM
extends AbstractRedisTool<String, String> {
    private static final long serialVersionUID = 8374950649752446530L;
    protected NumberTextField m_TextMarkerSize;
    protected ColorChooserPanel m_PanelColor;
    protected BaseCheckBox m_CheckBoxForeground;
    protected int m_MarkerSize;
    protected Color m_MarkerColor;
    protected boolean m_Foreground;
    protected transient String m_BaseImageBase64;

    public String globalInfo() {
        return "After connecting to the Redis server, click on one or more points with the left mouse button and then press ENTER to have a shape detected.\nLeft-Click while holding CTRL to reset the selected points.\nCommunicates with a SAM docker container using Redis.\n\nMore information:\nhttps://github.com/waikato-datamining/pytorch/tree/master/segment-anything";
    }

    public String getName() {
        return "SAM";
    }

    public Icon getIcon() {
        return ImageManager.getIcon((String)"sam.png");
    }

    protected Cursor createCursor() {
        if (this.m_Client == null) {
            return Cursor.getPredefinedCursor(0);
        }
        return Cursor.getPredefinedCursor(1);
    }

    protected ToolMouseAdapter createMouseListener() {
        return new ToolMouseAdapter((Tool)this){

            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick((MouseEvent)e) && MouseUtils.hasNoModifierKey((MouseEvent)e)) {
                    SAM.this.getLayerManager().getMarkers().add(new Point((int)((double)e.getX() / SAM.this.getZoom()), (int)((double)e.getY() / SAM.this.getZoom())));
                    e.consume();
                } else if (MouseUtils.isLeftClick((MouseEvent)e) && KeyUtils.isCtrlDown((int)e.getModifiersEx())) {
                    SAM.this.getLayerManager().getMarkers().clear();
                    e.consume();
                }
                super.mouseClicked(e);
            }
        };
    }

    protected ToolMouseMotionAdapter createMouseMotionListener() {
        return null;
    }

    protected ToolKeyAdapter createKeyListener() {
        return new ToolKeyAdapter((Tool)this){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SAM.this.m_Client != null && SAM.this.getLayerManager().getMarkers().size() >= 1) {
                    e.consume();
                    SAM.this.sendData();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        };
    }

    @Override
    protected void retrieveParameters() {
        super.retrieveParameters();
        this.m_MarkerSize = this.m_TextMarkerSize.getValue().intValue();
        this.m_MarkerColor = (Color)this.m_PanelColor.getCurrent();
        this.m_Foreground = this.m_CheckBoxForeground.isSelected();
        this.getLayerManager().getMarkers().setExtent(this.m_MarkerSize);
        this.getLayerManager().getMarkers().setColor(this.m_MarkerColor);
    }

    @Override
    protected String getSendChannel() {
        return "sam_in";
    }

    @Override
    protected String getReceiveChannel() {
        return "sam_out";
    }

    @Override
    protected int getDefaultTimeout() {
        return 60000;
    }

    @Override
    protected void addOptions(ParameterPanel paramPanel) {
        super.addOptions(paramPanel);
        this.m_TextMarkerSize = new NumberTextField(NumberTextField.Type.INTEGER, 10);
        this.m_TextMarkerSize.setCheckModel((CheckedTextField.AbstractCheckModel)new NumberTextField.BoundedNumberCheckModel(NumberTextField.Type.INTEGER, (Number)1, null, (Number)this.getLayerManager().getMarkers().getExtent()));
        this.m_TextMarkerSize.addAnyChangeListener(e -> this.setApplyButtonState(this.m_ButtonApply, true));
        paramPanel.addParameter("Marker size", (Component)this.m_TextMarkerSize);
        this.m_PanelColor = new ColorChooserPanel(this.getLayerManager().getMarkers().getColor());
        paramPanel.addParameter("- color", (Component)this.m_PanelColor);
        this.m_CheckBoxForeground = new BaseCheckBox();
        this.m_CheckBoxForeground.setSelected(true);
        this.m_CheckBoxForeground.setToolTipText("whether to identify a foreground or background object");
        paramPanel.addParameter("Foreground", (Component)this.m_CheckBoxForeground);
    }

    @Override
    protected RedisDataType getSendType() {
        return RedisDataType.STRING;
    }

    @Override
    protected RedisDataType getReceiveType() {
        return RedisDataType.STRING;
    }

    @Override
    protected String assembleSendData(MessageCollection errors) {
        JsonObject result = new JsonObject();
        if (this.m_BaseImageBase64 == null) {
            byte[] bytes = BufferedImageHelper.toBytes((BufferedImage)this.getLayerManager().getImageLayer().getImage(), (String)"JPG", (MessageCollection)errors);
            if (bytes != null) {
                this.m_BaseImageBase64 = Base64.getEncoder().encodeToString(bytes);
            } else {
                return null;
            }
        }
        result.addProperty("image", this.m_BaseImageBase64);
        JsonObject prompt = new JsonObject();
        result.add("prompt", (JsonElement)prompt);
        JsonArray points = new JsonArray();
        prompt.add("points", (JsonElement)points);
        for (Point p : this.getLayerManager().getMarkers().getPoints()) {
            JsonObject point = new JsonObject();
            point.addProperty("x", (Number)p.getX());
            point.addProperty("y", (Number)p.getY());
            point.addProperty("label", (Number)(this.m_Foreground ? 1 : 0));
            points.add((JsonElement)point);
        }
        return result.toString();
    }

    @Override
    protected void parseReceivedData(String data, MessageCollection errors) {
        int[] colors;
        if (data == null) {
            return;
        }
        JsonObject json = (JsonObject)JsonParser.parseString((String)data);
        String maskStr = json.get("mask").getAsString();
        byte[] bytes = Base64.getMimeDecoder().decode(maskStr);
        errors = new MessageCollection();
        BufferedImage maskImage = BufferedImageHelper.fromBytes((byte[])bytes, (MessageCollection)errors);
        int width = maskImage.getWidth();
        int height = maskImage.getHeight();
        int[] pixels = BufferedImageHelper.getPixels((BufferedImage)maskImage);
        ImageUtils.replaceColor((int[])pixels, (Color)Color.BLACK, (Color)new Color(0, 0, 0, 0));
        for (int color : colors = StatUtils.uniqueValues((int[])pixels)) {
            if (color == 0) continue;
            ImageUtils.replaceColor((int[])pixels, (Color)new Color(color), (Color)this.getActiveColor());
        }
        if (this.isAutomaticUndoEnabled()) {
            this.getCanvas().getOwner().addUndoPoint();
        }
        BufferedImage activeImage = this.getActiveImage();
        maskImage = new BufferedImage(width, height, activeImage.getType());
        maskImage.setRGB(0, 0, width, height, pixels, 0, width);
        ImageUtils.combineImages((BufferedImage)maskImage, (BufferedImage)activeImage);
    }

    @Override
    protected void finishedRequest() {
        super.finishedRequest();
        this.getLayerManager().getMarkers().clear();
        this.getLayerManager().update();
    }

    @Override
    public void annotationsChanged() {
        super.annotationsChanged();
        this.m_BaseImageBase64 = null;
    }
}

