/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer.crop;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.imagej.transformer.crop.AbstractCropAlgorithm;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractCropAlgorithmTestCase
extends AdamsTestCase {
    public AbstractCropAlgorithmTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/imagej/transformer/crop/data");
    }

    protected ImagePlus load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        String fullName = this.m_TestHelper.getTmpDirectory() + File.separator + filename;
        ImagePlus result = IJ.openImage((String)fullName);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected ImagePlus process(ImagePlus img, AbstractCropAlgorithm scheme) {
        return scheme.crop(img);
    }

    protected boolean save(ImagePlus data, String filename) {
        TmpFile file = new TmpFile(filename);
        StringBuilder content = new StringBuilder();
        content.append("Image:\n");
        content.append(data);
        content.append("\n");
        FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)content, (boolean)false);
        return file.exists();
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractCropAlgorithm[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
        }
        result = result + ".txt";
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractCropAlgorithm[] setups = this.getRegressionSetups();
        AbstractCropAlgorithmTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            ImagePlus data = this.load(input[i]);
            AbstractCropAlgorithmTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            ImagePlus processed = this.process(data, setups[i]);
            AbstractCropAlgorithmTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractCropAlgorithmTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        ArrayList<TmpFile> outputFiles = new ArrayList<TmpFile>();
        for (i = 0; i < output.length; ++i) {
            outputFiles.add(new TmpFile(output[i]));
        }
        String regression = this.m_Regression.compare((File[])outputFiles.toArray(new TmpFile[outputFiles.size()]));
        AbstractCropAlgorithmTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

