/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.ImageJWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.ImageJReader;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ImageJWriterTest
extends AbstractFlowTest {
    public ImageJWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_logo.jpg");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("adams_logo.png");
        this.m_TestHelper.deleteFileFromTmp("adams_logo.jpg");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("adams_logo.png")});
        ImageJReader ir = new ImageJReader();
        ImageJWriter iw = new ImageJWriter();
        iw.setImageType(ImageJWriter.ImageType.AUTO);
        iw.setOutputFile((PlaceholderFile)new TmpFile("adams_logo.jpg"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, ir, iw});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(ImageJWriterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ImageJWriterTest.runTest((Test)ImageJWriterTest.suite());
    }
}

