/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.crop.AbstractCropAlgorithm;
import adams.data.imagej.transformer.crop.NoCrop;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import ij.ImagePlus;

public class Crop
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected AbstractCropAlgorithm m_Algorithm;

    public String globalInfo() {
        return "Crops the images passing through using the specified crop algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new NoCrop());
    }

    public void setAlgorithm(AbstractCropAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractCropAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The crop algorithm to apply to the image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)((Object)this.m_Algorithm));
    }

    protected ImagePlusContainer[] doTransform(ImagePlusContainer img) {
        ImagePlusContainer result = (ImagePlusContainer)img.getHeader();
        result.setImage(this.m_Algorithm.crop((ImagePlus)img.getImage()));
        Report report = result.getReport();
        if (report != null) {
            report.addField((AbstractField)new Field("Crop.Left", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Top", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Right", DataType.NUMERIC));
            report.addField((AbstractField)new Field("Crop.Bottom", DataType.NUMERIC));
            report.setNumericValue("Crop.Left", this.m_Algorithm.getTopLeft().getX());
            report.setNumericValue("Crop.Top", this.m_Algorithm.getTopLeft().getY());
            report.setNumericValue("Crop.Right", this.m_Algorithm.getBottomRight().getX());
            report.setNumericValue("Crop.Bottom", this.m_Algorithm.getBottomRight().getY());
        }
        return new ImagePlusContainer[]{result};
    }
}

