/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.PassThrough;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFilterWithGOE;
import ij.ImagePlus;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Date;

public class ImageJTransformer
extends AbstractSelectedImagesFilterWithGOE {
    private static final long serialVersionUID = 9108452366270377935L;

    public String getMenu() {
        return "Filter";
    }

    public String getCaption() {
        return "ImageJ transformer...";
    }

    public String getIconName() {
        return "imagej.gif";
    }

    protected Class getEditorType() {
        return AbstractImageJTransformer.class;
    }

    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    protected BufferedImage filter(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        String title = ((ImagePanel)this.m_CurrentPanel).getCurrentFile() != null ? ((ImagePanel)this.m_CurrentPanel).getCurrentFile().toString() : "" + new Date();
        AbstractImageJTransformer transformer = (AbstractImageJTransformer)((Object)this.getLastSetup());
        ImagePlusContainer input = new ImagePlusContainer();
        input.setImage(new ImagePlus(title, (Image)image));
        ImagePlusContainer[] transformed = (ImagePlusContainer[])transformer.transform(input);
        if (transformed.length == 0) {
            this.m_FilterError = "No filtered image generated!";
        }
        if (transformed.length > 1) {
            this.getLogger().severe("WARNING: Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = ((ImagePlus)transformed[0].getImage()).getBufferedImage();
        }
        return result;
    }
}

