/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractImageJTransformerTestCase
extends AdamsTestCase {
    public AbstractImageJTransformerTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/imagej/transformer/data");
    }

    protected ImagePlusContainer load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        String fullName = this.m_TestHelper.getTmpDirectory() + File.separator + filename;
        ImagePlus img = IJ.openImage((String)fullName);
        ImagePlusContainer result = new ImagePlusContainer();
        result.setImage((Object)img);
        result.getReport().setStringValue("Filename", filename);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected ImagePlusContainer[] process(ImagePlusContainer img, AbstractImageJTransformer scheme) {
        return (ImagePlusContainer[])scheme.transform((AbstractImageContainer)img);
    }

    protected boolean save(ImagePlusContainer data, String filename) {
        TmpFile file = new TmpFile(filename);
        StringBuilder content = new StringBuilder();
        content.append("Image:\n");
        content.append(data.getImage());
        content.append(Utils.flatten((Object[])Utils.breakUp((String)((ImagePlus)data.getImage()).toString(), (int)80), (String)"\n"));
        content.append("\n");
        content.append("Report:\n");
        Report report = data.getReport().getClone();
        report.removeValue((AbstractField)new Field("Filename", DataType.STRING));
        content.append(report);
        content.append("\n");
        content.append("Notes:\n");
        content.append(data.getNotes());
        content.append("\n");
        FileUtils.writeToFile((String)file.getAbsolutePath(), (Object)content, (boolean)false);
        return file.exists();
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractImageJTransformer[] getRegressionSetups();

    protected String createOutputFilename(String input, int no, int imgNo) {
        String result;
        String ext = "-out" + no + "_" + imgNo;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
        }
        result = result + ".txt";
        return result;
    }

    public void testRegression() {
        int n;
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[][] output = new String[input.length][];
        AbstractImageJTransformer[] setups = this.getRegressionSetups();
        AbstractImageJTransformerTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            ImagePlusContainer data = this.load(input[i]);
            AbstractImageJTransformerTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            ImagePlusContainer[] processed = this.process(data, setups[i]);
            AbstractImageJTransformerTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = new String[processed.length];
            for (n = 0; n < output[i].length; ++n) {
                output[i][n] = this.createOutputFilename(input[i], i, n);
                boolean ok = this.save(processed[n], output[i][n]);
                AbstractImageJTransformerTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            }
        }
        ArrayList<TmpFile> outputFiles = new ArrayList<TmpFile>();
        for (i = 0; i < output.length; ++i) {
            for (n = 0; n < output[i].length; ++n) {
                outputFiles.add(new TmpFile(output[i][n]));
            }
        }
        String regression = this.m_Regression.compare((File[])outputFiles.toArray(new TmpFile[outputFiles.size()]));
        AbstractImageJTransformerTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            for (n = 0; n < output[i].length; ++n) {
                this.m_TestHelper.deleteFileFromTmp(output[i][n]);
            }
        }
    }
}

