/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import ij.IJ;
import ij.ImagePlus;
import java.util.Date;

public class Macro
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 3739155764347863440L;
    protected BaseText m_Commands;

    public String globalInfo() {
        return "Executes the macro commands to transform the image.\nDue to ImageJ's architecture, only a single ImageJ instance is available in a process at any given time. Interacting with ImageJ while running a macro will lead to unpredictable side-effects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("commands", "commands", (Object)new BaseText());
    }

    public void setCommands(BaseText value) {
        this.m_Commands = value;
        this.reset();
    }

    public BaseText getCommands() {
        return this.m_Commands;
    }

    public String commandsTipText() {
        return "The macro commands to transform the image width.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"commands", (Object)Shortening.shortenEnd((String)this.m_Commands.stringValue(), (int)40));
    }

    protected ImagePlusContainer[] doTransform(ImagePlusContainer img) {
        if (this.m_Commands.getValue().trim().length() == 0) {
            return new ImagePlusContainer[]{img};
        }
        ImagePlus im = (ImagePlus)img.getImage();
        IJ.newImage((String)(((Object)((Object)this)).hashCode() + " - " + new Date()), (String)"RGB", (int)im.getWidth(), (int)im.getHeight(), (int)1);
        ImagePlus imNew = IJ.getImage();
        imNew.setImage(im.getImage());
        IJ.runMacro((String)this.m_Commands.getValue());
        ImagePlusContainer[] result = new ImagePlusContainer[]{(ImagePlusContainer)img.getHeader()};
        result[0].setImage(IJ.getImage());
        if (IJ.getImage() != imNew) {
            imNew.close();
        }
        IJ.getImage().close();
        return result;
    }
}

