/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.imagej.features.Pixels;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.PassThrough;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilteredImageJFeatureGenerator
extends AbstractImageJFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected AbstractImageJTransformer m_Filter;
    protected AbstractImageJFeatureGenerator m_Generator;

    public String globalInfo() {
        return "Applies the filter (an image transformer) to the image first before generating the features from the transformed images.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
        this.m_OptionManager.add("generator", "generator", (Object)new Pixels());
    }

    public void setFilter(AbstractImageJTransformer value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractImageJTransformer getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use.";
    }

    public void setGenerator(AbstractImageJFeatureGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractImageJFeatureGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use on the filtered data.";
    }

    public HeaderDefinition createHeader(ImagePlusContainer img) {
        ImagePlusContainer[] conts = (ImagePlusContainer[])this.m_Filter.transform(img);
        HeaderDefinition result = this.m_Generator.postProcessHeader(this.m_Generator.createHeader(conts[0]));
        return result;
    }

    public List<Object>[] generateRows(ImagePlusContainer img) {
        List[] result;
        ImagePlusContainer[] conts;
        ArrayList<List> rows = new ArrayList<List>();
        for (ImagePlusContainer cont : conts = (ImagePlusContainer[])this.m_Filter.transform(img)) {
            result = this.m_Generator.postProcessRows(cont, this.m_Generator.generateRows(cont));
            rows.addAll(Arrays.asList(result));
        }
        result = new List[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            result[i] = (List)rows.get(i);
        }
        return result;
    }
}

