/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import java.util.ArrayList;
import java.util.Arrays;

public class MultiTransformer
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 7793661256600883689L;
    protected AbstractImageJTransformer[] m_Transformers;

    public String globalInfo() {
        return "Applies the specified ImageJ transformers one after the other.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformers", (Object)new AbstractImageJTransformer[0]);
    }

    public void setTransformers(AbstractImageJTransformer[] value) {
        this.m_Transformers = value;
        this.reset();
    }

    public AbstractImageJTransformer[] getTransformers() {
        return this.m_Transformers;
    }

    public String transformersTipText() {
        return "The transformers to apply one after the other.";
    }

    protected ImagePlusContainer[] doTransform(ImagePlusContainer img) {
        ArrayList<AbstractImageContainer> result = new ArrayList<AbstractImageContainer>();
        result.add(img);
        ArrayList<AbstractImageContainer> input = new ArrayList<AbstractImageContainer>();
        for (int i = 0; i < this.m_Transformers.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Transformer #" + (i + 1) + "...");
            }
            input.clear();
            input.addAll(result);
            result.clear();
            for (ImagePlusContainer imagePlusContainer : input) {
                result.addAll(Arrays.asList(this.m_Transformers[i].transform(imagePlusContainer)));
            }
        }
        return result.toArray(new ImagePlusContainer[result.size()]);
    }
}

