/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer.crop;

import adams.core.option.AbstractOptionHandler;
import adams.data.image.CropAlgorithm;
import ij.ImagePlus;
import java.awt.Point;

public abstract class AbstractCropAlgorithm
extends AbstractOptionHandler
implements CropAlgorithm<ImagePlus> {
    private static final long serialVersionUID = 776508705083560079L;
    protected Point m_TopLeft;
    protected Point m_BottomRight;

    protected void check(ImagePlus img) {
        if (img == null) {
            throw new IllegalStateException("No image supplied!");
        }
    }

    protected void preCrop(ImagePlus img) {
        this.m_TopLeft = new Point(0, 0);
        this.m_BottomRight = new Point(img.getWidth(), img.getHeight());
    }

    protected abstract ImagePlus doCrop(ImagePlus var1);

    protected void postCrop(ImagePlus img) {
    }

    public ImagePlus crop(ImagePlus img) {
        this.check(img);
        this.preCrop(img);
        ImagePlus result = this.doCrop(img);
        this.postCrop(result);
        return result;
    }

    public Point getTopLeft() {
        return this.m_TopLeft;
    }

    public Point getBottomRight() {
        return this.m_BottomRight;
    }
}

