/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick;

import adams.core.io.FileUtils;
import adams.data.imagemagick.PPMOutputConsumer;
import adams.env.Environment;
import java.awt.image.BufferedImage;
import java.io.File;
import org.im4java.core.Operation;
import org.im4java.core.UFRawCmd;
import org.im4java.core.UFRawOperation;
import org.im4java.process.OutputConsumer;

public class UFRawHelper {
    public static final String ENV_PATH = "UFRAW_TOOLPATH";
    protected static Boolean m_UfrawPresent;

    public static boolean isUfrawAvailable() {
        if (m_UfrawPresent == null) {
            String exec = FileUtils.fixExecutable((String)"ufraw");
            String path = System.getenv(ENV_PATH);
            if (path != null) {
                exec = path + File.separator + exec;
            }
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{exec, "--version"});
                m_UfrawPresent = proc.waitFor() == 0;
            }
            catch (Exception e) {
                System.err.println("Failed to execute '" + exec + "':");
                e.printStackTrace();
                m_UfrawPresent = false;
            }
        }
        return m_UfrawPresent;
    }

    public static String getMissingUfrawErrorMessage() {
        return "ufraw not installed or UFRAW_TOOLPATH environment variable not pointing to installation!";
    }

    public static BufferedImage read(File file) {
        BufferedImage result;
        UFRawOperation op = new UFRawOperation();
        op.addImage(new String[]{file.getAbsolutePath()});
        op.outType("ppm");
        op.output("-");
        PPMOutputConsumer joc = new PPMOutputConsumer();
        UFRawCmd cmd = new UFRawCmd(true);
        cmd.setOutputConsumer((OutputConsumer)joc);
        try {
            cmd.run((Operation)op, new Object[0]);
            result = joc.getImage();
        }
        catch (Exception e) {
            result = null;
            System.err.println("Failed to read image from file '" + file + "':");
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        System.out.println("Tool availability:");
        System.out.println("- ufraw? " + UFRawHelper.isUfrawAvailable());
    }
}

