/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick.dcraw;

import adams.core.AtomicMoveSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.imagemagick.AbstractImageOperation;
import adams.data.imagemagick.DCRawHelper;
import java.io.File;

public abstract class AbstractDcrawOperation
extends AbstractImageOperation
implements AtomicMoveSupporter {
    private static final long serialVersionUID = 4447009209054143230L;
    protected boolean m_AtomicMove;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("atomic-move", "atomicMove", (Object)false);
    }

    public void setAtomicMove(boolean value) {
        this.m_AtomicMove = value;
        this.reset();
    }

    public boolean getAtomicMove() {
        return this.m_AtomicMove;
    }

    public String atomicMoveTipText() {
        return "If true, then an atomic move operation will be attempted (NB: not supported by all operating systems).";
    }

    @Override
    protected String check(PlaceholderFile input, PlaceholderFile output) {
        if (!DCRawHelper.isDcrawAvailable()) {
            return DCRawHelper.getMissingDcrawErrorMessage();
        }
        return super.check(input, output);
    }

    protected String move(PlaceholderFile input, PlaceholderFile output) {
        String result = null;
        PlaceholderFile tmp = FileUtils.replaceExtension((PlaceholderFile)input, (String)".ppm");
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Moving tmp file '" + tmp + "' to '" + output + "'...");
        }
        try {
            if (!FileUtils.move((File)tmp, (File)output, (boolean)this.m_AtomicMove)) {
                result = "Failed to move file '" + tmp + "' to '" + output + "'!";
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to move file '" + tmp + "' to '" + output + "'!"), (Throwable)e);
        }
        if (result == null && this.isLoggingEnabled()) {
            this.getLogger().info("Moved tmp file '" + tmp + "' successfully to '" + output + "'.");
        }
        return result;
    }
}

