/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.openimaj.facedetector.AbstractFaceDetector;
import adams.data.openimaj.facedetector.HaarCascade;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.detection.DetectedFace;

public class OpenIMAJFaceDetector
extends AbstractObjectLocator {
    private static final long serialVersionUID = -5521919703087480870L;
    protected AbstractFaceDetector m_Detector;

    public String globalInfo() {
        return "Uses the specified OpenIMAJ face detector algorithm to locate faces.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "detector", (Object)new HaarCascade());
    }

    public void setDetector(AbstractFaceDetector value) {
        this.m_Detector = value;
        this.reset();
    }

    public AbstractFaceDetector getDetector() {
        return this.m_Detector;
    }

    public String detectorTipText() {
        return "The detector algorithm to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"detector", (Object)((Object)this.m_Detector), (String)"detector: ");
    }

    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)image);
        List<DetectedFace> detected = this.m_Detector.detectFaces((AbstractImageContainer)cont);
        LocatedObjects result = new LocatedObjects();
        for (DetectedFace face : detected) {
            LocatedObject obj = new LocatedObject(ImageUtilities.createBufferedImage((FImage)face.getFacePatch()), (int)face.getBounds().x, (int)face.getBounds().y, (int)face.getBounds().width, (int)face.getBounds().height);
            result.add((Object)obj);
        }
        return result;
    }
}

