/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.OpenIMAJImageWriter;
import adams.data.openimaj.OpenIMAJImageContainer;
import adams.data.openimaj.OpenIMAJImageType;
import java.io.File;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class OpenIMAJImageReader
extends AbstractImageReader<OpenIMAJImageContainer> {
    private static final long serialVersionUID = -3454639551353467146L;
    protected OpenIMAJImageType m_ImageType;
    protected boolean m_Alpha;

    public String globalInfo() {
        return "OpenIMAJ image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\nFor more information see:\nhttp://www.openimaj.org/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)OpenIMAJImageType.MBFIMAGE);
        this.m_OptionManager.add("alpha", "alpha", (Object)false);
    }

    public void setImageType(OpenIMAJImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public OpenIMAJImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The OpenIMAJ image type to use when reading the image.";
    }

    public void setAlpha(boolean value) {
        this.m_Alpha = value;
        this.reset();
    }

    public boolean getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "Whether to include an alpha channel in case of multi-band images.";
    }

    public String getFormatDescription() {
        return "OpenIMAJ images";
    }

    public String[] getFormatExtensions() {
        return new String[]{"png", "*"};
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return new OpenIMAJImageWriter();
    }

    protected OpenIMAJImageContainer doRead(PlaceholderFile file) {
        OpenIMAJImageContainer result = new OpenIMAJImageContainer();
        try {
            switch (this.m_ImageType) {
                case FIMAGE: {
                    FImage img = ImageUtilities.readF((File)file.getAbsoluteFile());
                    result.setImage(img);
                    break;
                }
                case MBFIMAGE: {
                    MBFImage img = this.m_Alpha ? ImageUtilities.readMBFAlpha((File)file.getAbsoluteFile()) : ImageUtilities.readMBF((File)file.getAbsoluteFile());
                    result.setImage(img);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled image type: " + (Object)((Object)this.m_ImageType));
                }
            }
        }
        catch (Exception e) {
            Utils.handleException((LoggingSupporter)this, (String)("Failed to read image as " + (Object)((Object)this.m_ImageType) + ": " + file), (Throwable)e);
            result = null;
        }
        return result;
    }
}

