/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.OpenIMAJImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.openimaj.OpenIMAJImageContainer;
import java.io.File;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;

public class OpenIMAJImageWriter
extends AbstractImageWriter<OpenIMAJImageContainer> {
    private static final long serialVersionUID = -8205381422416173255L;

    public String globalInfo() {
        return "OpenIMAJ image writer for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\nFor more information see:\nhttp://www.openimaj.org/";
    }

    public String getFormatDescription() {
        return "OpenIMAJ images";
    }

    public String[] getFormatExtensions() {
        return new String[]{"png", "*"};
    }

    public AbstractImageReader getCorrespondingReader() {
        return new OpenIMAJImageReader();
    }

    protected String doWrite(PlaceholderFile file, OpenIMAJImageContainer cont) {
        try {
            ImageUtilities.write((Image)((Image)cont.getImage()), (File)file.getAbsoluteFile());
            return null;
        }
        catch (Exception e) {
            return Utils.handleException((LoggingSupporter)this, (String)("Failed to write OpenIMAJ image to: " + file), (Throwable)e);
        }
    }
}

