/*
 * Decompiled with CFR 0.152.
 */
package adams.data.openimaj.facedetector;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.openimaj.facedetector.AbstractFaceDetector;
import java.awt.image.BufferedImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.detection.CLMFaceDetector;
import org.openimaj.image.processing.face.detection.FaceDetector;

public class ConstrainedLocalModel
extends AbstractFaceDetector
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 4304163800543325831L;

    public String globalInfo() {
        return "Face detector based on a constrained local model. Fits a 3D face model to each detection.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jason M. Saragih and Simon Lucey and Jeffrey F. Cohn");
        result.setValue(TechnicalInformation.Field.TITLE, "Face alignment through subspace constrained mean-shifts");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IEEE 12th International Conference on Computer Vision, ICCV 2009, Kyoto, Japan, September 27 - October 4, 2009");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.PAGES, "1034-1041");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "IEEE");
        return result;
    }

    @Override
    protected FaceDetector newInstance() {
        return new CLMFaceDetector();
    }

    @Override
    protected Image convert(AbstractImageContainer cont) {
        return ImageUtilities.createFImage((BufferedImage)cont.toBufferedImage());
    }
}

