/*
 * Decompiled with CFR 0.152.
 */
package adams.data.openimaj.facedetector;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.openimaj.facedetector.AbstractFaceDetector;
import adams.data.openimaj.facedetector.AbstractMetaFaceDetector;
import adams.data.openimaj.facedetector.HaarCascade;
import java.awt.image.BufferedImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.detection.keypoints.FKEFaceDetector;

public class FrontalKeypointEnriched
extends AbstractMetaFaceDetector
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 4304163800543325831L;
    protected float m_PatchScale;

    public String globalInfo() {
        return "A face detector that uses an underlying face detector to detect frontal faces in an image, and then looks for facial keypoints within the detections. \n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Everingham and Josef Sivic and Andrew Zisserman");
        result.setValue(TechnicalInformation.Field.TITLE, "Hello! My name is... Buffy - Automatic naming of characters in TV video");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "In BMVC");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("patch-scale", "patchScale", (Object)Float.valueOf(1.0f), (Number)Float.valueOf(0.0f), null);
    }

    @Override
    protected AbstractFaceDetector getDefaultDetector() {
        return new HaarCascade();
    }

    public void setPatchScale(float value) {
        this.m_PatchScale = value;
        this.reset();
    }

    public float getPatchScale() {
        return this.m_PatchScale;
    }

    public String patchScaleTipText() {
        return "The scale of the patch compared to the patch extracted by the internal detector.";
    }

    @Override
    protected FaceDetector newInstance() {
        FaceDetector base = this.m_Detector.newInstance();
        FKEFaceDetector result = new FKEFaceDetector(base, this.m_PatchScale);
        return result;
    }

    @Override
    protected Image convert(AbstractImageContainer cont) {
        return ImageUtilities.createFImage((BufferedImage)cont.toBufferedImage());
    }
}

