/*
 * Decompiled with CFR 0.152.
 */
package adams.data.openimaj.facedetector;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.openimaj.facedetector.AbstractFaceDetector;
import java.awt.image.BufferedImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;

public class HaarCascade
extends AbstractFaceDetector
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 4304163800543325831L;
    protected PlaceholderFile m_Cascade;
    protected int m_MinSize;

    public String globalInfo() {
        return "A face detector based on a Haar cascade. The cascades provided by HaarCascadeDetector.BuiltInCascade are the same as those available in OpenCV.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Viola, P. and Jones, M.");
        result.setValue(TechnicalInformation.Field.TITLE, "Rapid object detection using a boosted cascade of simple features");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on");
        result.setValue(TechnicalInformation.Field.PAGES, "I, 511, I, 518 vol.1");
        result.setValue(TechnicalInformation.Field.VOLUME, "1");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cascade", "cascade", (Object)new PlaceholderFile());
        this.m_OptionManager.add("min-size", "minSize", (Object)-1, (Number)-1, null);
    }

    public void setCascade(PlaceholderFile value) {
        this.m_Cascade = value;
        this.reset();
    }

    public PlaceholderFile getCascade() {
        return this.m_Cascade;
    }

    public String cascadeTipText() {
        return "The cascade to use.";
    }

    public void setMinSize(int value) {
        this.m_MinSize = value;
        this.reset();
    }

    public int getMinSize() {
        return this.m_MinSize;
    }

    public String minSizeTipText() {
        return "The minimum search window size.";
    }

    @Override
    protected FaceDetector newInstance() {
        if (this.m_Cascade.exists() && this.m_Cascade.isFile()) {
            if (this.m_MinSize > -1) {
                return new HaarCascadeDetector(this.m_Cascade.getAbsolutePath(), this.m_MinSize);
            }
            return new HaarCascadeDetector(this.m_Cascade.getAbsolutePath());
        }
        if (this.m_MinSize > -1) {
            return new HaarCascadeDetector(this.m_MinSize);
        }
        return new HaarCascadeDetector();
    }

    @Override
    protected Image convert(AbstractImageContainer cont) {
        return ImageUtilities.createFImage((BufferedImage)cont.toBufferedImage());
    }
}

