/*
 * Decompiled with CFR 0.152.
 */
package adams.data.openimaj.facedetector;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.openimaj.facedetector.AbstractFaceDetector;
import java.awt.image.BufferedImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.detection.SandeepFaceDetector;

public class Sandeep
extends AbstractFaceDetector
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 4304163800543325831L;

    public String globalInfo() {
        return "Implementation of a face detector along the lines of \"Human Face Detection in Cluttered Color Images Using Skin Color and Edge Information\" K. Sandeep and A. N. Rajagopalan (IIT/Madras).";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Sandeep, K and Rajagopalan, A N");
        result.setValue(TechnicalInformation.Field.TITLE, "Human Face Detection in Cluttered Color Images Using Skin Color and Edge Information");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Electrical Engineering");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.HTTP, "http://citeseerx.ist.psu.edu/viewdoc/download?doi:10.1.1.12.730&rep:rep1&type:pdf");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "citeseer");
        return result;
    }

    @Override
    protected FaceDetector newInstance() {
        return new SandeepFaceDetector();
    }

    @Override
    protected Image convert(AbstractImageContainer cont) {
        return ImageUtilities.createMBFImage((BufferedImage)cont.toBufferedImage(), (boolean)false);
    }
}

