/*
 * Decompiled with CFR 0.152.
 */
package adams.data.openimaj.objectdetector;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.image.AbstractImageContainer;
import adams.data.openimaj.objectdetector.AbstractObjectDetector;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.objectdetection.ObjectDetector;
import org.openimaj.image.objectdetection.haar.Detector;
import org.openimaj.image.objectdetection.haar.OCVHaarLoader;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;

public class HaarCascade
extends AbstractObjectDetector
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -525543205188155627L;
    protected PlaceholderFile m_Cascade;
    protected int m_MinSize;

    public String globalInfo() {
        return "An object detector based on a Haar cascade.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Viola, P. and Jones, M.");
        result.setValue(TechnicalInformation.Field.TITLE, "Rapid object detection using a boosted cascade of simple features");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on");
        result.setValue(TechnicalInformation.Field.PAGES, "I, 511, I, 518 vol.1");
        result.setValue(TechnicalInformation.Field.VOLUME, "1");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cascade", "cascade", (Object)new PlaceholderFile());
        this.m_OptionManager.add("min-size", "minSize", (Object)-1, (Number)-1, null);
    }

    public void setCascade(PlaceholderFile value) {
        this.m_Cascade = value;
        this.reset();
    }

    public PlaceholderFile getCascade() {
        return this.m_Cascade;
    }

    public String cascadeTipText() {
        return "The cascade to use.";
    }

    public void setMinSize(int value) {
        this.m_MinSize = value;
        this.reset();
    }

    public int getMinSize() {
        return this.m_MinSize;
    }

    public String minSizeTipText() {
        return "The minimum search window size.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ObjectDetector newInstance() {
        StageTreeClassifier cascade;
        if (!this.m_Cascade.exists()) {
            throw new IllegalStateException("Cascade file does not exist: " + this.m_Cascade);
        }
        if (this.m_Cascade.isDirectory()) {
            throw new IllegalStateException("Cascade file points to directory: " + this.m_Cascade);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.m_Cascade.getAbsoluteFile());
            cascade = OCVHaarLoader.read((InputStream)fis);
        }
        catch (Exception e) {
            ObjectDetector objectDetector;
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read cascade!", (Throwable)e);
                objectDetector = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
            return objectDetector;
        }
        FileUtils.closeQuietly((InputStream)fis);
        Detector result = new Detector(cascade);
        if (this.m_MinSize > -1) {
            result.setMinimumDetectionSize(this.m_MinSize);
        }
        return result;
    }

    @Override
    protected Image convert(AbstractImageContainer cont) {
        return ImageUtilities.createFImage((BufferedImage)cont.toBufferedImage());
    }
}

