/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.openimaj.objectdetector.AbstractObjectDetector;
import adams.data.openimaj.objectdetector.HaarCascade;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;
import java.util.List;
import org.openimaj.math.geometry.shape.Rectangle;

public class OpenIMAJObjectDetector
extends AbstractObjectLocator {
    private static final long serialVersionUID = -5521919703087480870L;
    protected AbstractObjectDetector m_Detector;

    public String globalInfo() {
        return "Uses the specified OpenIMAJ object detector algorithm to locate objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("detector", "detector", (Object)new HaarCascade());
    }

    public void setDetector(AbstractObjectDetector value) {
        this.m_Detector = value;
        this.reset();
    }

    public AbstractObjectDetector getDetector() {
        return this.m_Detector;
    }

    public String detectorTipText() {
        return "The detector algorithm to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"detector", (Object)((Object)this.m_Detector), (String)"detector: ");
    }

    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)image);
        List detected = this.m_Detector.detect((AbstractImageContainer)cont);
        LocatedObjects result = new LocatedObjects();
        for (Object object : detected) {
            if (object instanceof Rectangle) {
                Rectangle rect = (Rectangle)object;
                LocatedObject obj = new LocatedObject(image.getSubimage((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height), (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
                result.add((Object)obj);
                continue;
            }
            this.getLogger().warning("Unhandled detected object type: " + Utils.classToString(object));
        }
        return result;
    }
}

