/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.conversion.BufferedImageToOtherFormatConversion;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.openimaj.OpenIMAJImageContainer;
import adams.data.openimaj.OpenIMAJImageType;
import java.awt.image.BufferedImage;
import org.openimaj.image.ImageUtilities;

public class BufferedImageToOpenIMAJ
extends AbstractConversion
implements BufferedImageToOtherFormatConversion {
    private static final long serialVersionUID = 267299130050379610L;
    protected OpenIMAJImageType m_ImageType;
    protected boolean m_Alpha;

    public String globalInfo() {
        return "Turns a BufferedImage container into an OpenIMAJ one.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-type", "imageType", (Object)OpenIMAJImageType.MBFIMAGE);
        this.m_OptionManager.add("alpha", "alpha", (Object)false);
    }

    public void setImageType(OpenIMAJImageType value) {
        this.m_ImageType = value;
        this.reset();
    }

    public OpenIMAJImageType getImageType() {
        return this.m_ImageType;
    }

    public String imageTypeTipText() {
        return "The OpenIMAJ image type to use.";
    }

    public void setAlpha(boolean value) {
        this.m_Alpha = value;
        this.reset();
    }

    public boolean getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "Whether to include an alpha channel in case of multi-band images.";
    }

    public Class accepts() {
        return AbstractImageContainer.class;
    }

    public Class generates() {
        return OpenIMAJImageContainer.class;
    }

    protected Object doConvert() throws Exception {
        BufferedImageContainer input = (BufferedImageContainer)this.m_Input;
        OpenIMAJImageContainer result = new OpenIMAJImageContainer();
        result.setReport(input.getReport().getClone());
        result.setNotes(input.getNotes().getClone());
        switch (this.m_ImageType) {
            case FIMAGE: {
                result.setImage(ImageUtilities.createFImage((BufferedImage)input.toBufferedImage()));
                break;
            }
            case MBFIMAGE: {
                result.setImage(ImageUtilities.createMBFImage((BufferedImage)input.toBufferedImage(), (boolean)this.m_Alpha));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled image type: " + (Object)((Object)this.m_ImageType));
            }
        }
        return result;
    }
}

